/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage.single;

import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;

public class SingleElementStorageWrapper
implements ISingleElementStorage {
    private final ElementType elementType;
    private final IElementStorage storage;

    public SingleElementStorageWrapper(ElementType elementType, IElementStorage storage) {
        this.elementType = elementType;
        this.storage = storage;
    }

    public IElementStorage getParent() {
        return this.storage;
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public int getElementAmount() {
        return this.storage.getElementAmount(this.elementType);
    }

    @Override
    public int getElementCapacity() {
        return this.storage.getElementCapacity(this.elementType);
    }

    @Override
    public int insertElement(int count, ElementType type, boolean simulate) {
        return this.storage.insertElement(count, type, simulate);
    }

    @Override
    public int extractElement(int count, ElementType type, boolean simulate) {
        return this.storage.extractElement(count, type, simulate);
    }
}

