/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage.single;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.EmptyElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISettableSingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.sync.AbstractSynchronizable;

public class SingleElementStorage
extends AbstractSynchronizable
implements ISettableSingleElementStorage,
INBTSerializable<CompoundTag> {
    protected int elementAmount;
    protected int elementCapacity;
    protected ElementType elementType;

    public SingleElementStorage(ElementType elementType, int elementCapacity) {
        this(elementType, elementCapacity, null);
    }

    public SingleElementStorage(ElementType elementType, int elementCapacity, Runnable syncCallback) {
        this(elementType, 0, elementCapacity, syncCallback);
    }

    public SingleElementStorage(ElementType elementType, int elementAmount, int elementCapacity, Runnable syncCallback) {
        super(syncCallback);
        this.elementType = elementType;
        this.elementCapacity = elementCapacity;
        this.elementAmount = elementAmount;
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public int getElementCapacity() {
        return this.elementCapacity;
    }

    @Override
    public void setElementAmount(int newCount) {
        this.elementAmount = newCount;
        this.markDirty();
    }

    @Override
    public ISingleElementStorage forElement(ElementType type) {
        if (type != this.elementType) {
            return EmptyElementStorage.getSingle(type);
        }
        return this;
    }

    public String toString() {
        return this.elementAmount + "/" + this.elementCapacity + " " + this.elementType.getSerializedName();
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        compound.putString("element_type", this.getElementType().getSerializedName());
        compound.putInt("element_amount", this.getElementAmount());
        compound.putInt("element_capacity", this.getElementCapacity());
        return compound;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        this.elementType = ElementType.byName(compound.getString("element_type"));
        this.elementAmount = compound.getInt("element_amount");
        this.elementCapacity = compound.getInt("element_capacity");
    }
}

