/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage.single;

import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;

public interface ISettableSingleElementStorage
extends ISingleElementStorage {
    public void setElementAmount(int var1);

    @Override
    default public int insertElement(int count, ElementType type, boolean simulate) {
        ElementType elementType = this.getElementType();
        int elementCapacity = this.getElementCapacity();
        int elementAmount = this.getElementAmount();
        if (type != elementType) {
            return count;
        }
        int newCount = Math.min(elementAmount + count, elementCapacity);
        if (newCount < 0) {
            newCount = elementCapacity;
        }
        if (!simulate) {
            this.setElementAmount(newCount);
        }
        return count - (newCount - elementAmount);
    }

    @Override
    default public int extractElement(int count, ElementType type, boolean simulate) {
        ElementType elementType = this.getElementType();
        int elementCapacity = this.getElementCapacity();
        int elementAmount = this.getElementAmount();
        if (type != elementType) {
            return 0;
        }
        int newCount = Math.max(elementAmount - count, 0);
        if (newCount > elementCapacity) {
            newCount = 0;
        }
        if (!simulate) {
            this.setElementAmount(newCount);
        }
        return elementAmount - newCount;
    }
}

