/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.EmptyElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorageWrapper;

public interface IElementStorage {
    public static IElementStorage empty() {
        return EmptyElementStorage.INSTANCE;
    }

    public int getElementAmount(ElementType var1);

    public int getElementCapacity(ElementType var1);

    public int insertElement(int var1, ElementType var2, boolean var3);

    public int extractElement(int var1, ElementType var2, boolean var3);

    default public int transferTo(IElementStorage other, ElementType type, int count) {
        return this.transferTo(other, type, count, 1.0f);
    }

    default public int transferTo(IElementStorage other, ElementType type, float count, float multiplier) {
        if (count <= 0.0f) {
            return 0;
        }
        int amount = Math.round((float)this.extractElement(Math.max(1, Math.round(count / multiplier)), type, true) * multiplier);
        amount -= other.insertElement(amount, type, true);
        this.extractElement(Math.round((float)amount / multiplier), type, false);
        other.insertElement(amount, type, false);
        return amount;
    }

    default public boolean canPipeInsert(ElementType type, @Nullable Direction side) {
        return type != ElementType.NONE;
    }

    default public boolean canPipeExtract(ElementType type, @Nullable Direction side) {
        return type != ElementType.NONE;
    }

    default public boolean doesRenderGauge(Player player) {
        return false;
    }

    default public boolean usableInInventory() {
        return false;
    }

    default public boolean isEmpty() {
        return ElementType.ALL_VALID.stream().mapToInt(this::getElementAmount).allMatch(i -> i <= 0);
    }

    default public void fill() {
        ElementType.ALL_VALID.forEach(this::fill);
    }

    default public void fill(ElementType type) {
        this.insertElement(this.getElementCapacity(type), type, false);
    }

    default public ISingleElementStorage forElement(ElementType type) {
        if (type == ElementType.NONE) {
            return EmptyElementStorage.getSingle(type);
        }
        return new SingleElementStorageWrapper(type, this);
    }

    default public int transferAll(IElementStorage target) {
        return ElementType.ALL_VALID.stream().mapToInt(type -> this.transferTo(target, (ElementType)type, this.getElementAmount((ElementType)type))).sum();
    }
}

