/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.IElementTypeProvider;

public enum ElementType implements StringRepresentable,
IElementTypeProvider
{
    NONE("none", 0, 0, 0),
    WATER("water", 43, 173, 255),
    FIRE("fire", 247, 107, 27),
    EARTH("earth", 13, 128, 37),
    AIR("air", 238, 255, 219);

    public static final List<ElementType> ALL_VALID;
    public static final Codec<ElementType> CODEC;
    public static final StreamCodec<ByteBuf, ElementType> STREAM_CODEC;
    private final String name;
    private final float r;
    private final float g;
    private final float b;
    private final int color;

    private ElementType(String name, int r, int g, int b) {
        this.name = name;
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.color = Mth.color((float)this.r, (float)this.g, (float)this.b);
    }

    public float getRed() {
        return this.r;
    }

    public float getGreen() {
        return this.g;
    }

    public float getBlue() {
        return this.b;
    }

    public int getColor() {
        return this == NONE ? -1 : this.color;
    }

    public static ElementType random() {
        return ElementType.random(RandomSource.create());
    }

    public static ElementType random(RandomSource rand) {
        int random = rand.nextInt(4);
        return switch (random) {
            case 0 -> WATER;
            case 1 -> FIRE;
            case 2 -> EARTH;
            case 3 -> AIR;
            default -> NONE;
        };
    }

    @Nonnull
    public String getSerializedName() {
        return this.name;
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this;
    }

    public String getDescriptionId() {
        return "element.elementalcraft." + this.getSerializedName();
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public static ElementType byName(String name) {
        for (ElementType elementType : ElementType.values()) {
            if (!elementType.name.equals(name)) continue;
            return elementType;
        }
        return NONE;
    }

    public static ElementType getElementType(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof IElementTypeProvider) {
            IElementTypeProvider provider = (IElementTypeProvider)block;
            return provider.getElementType();
        }
        return NONE;
    }

    public static ElementType getElementType(ItemStack stack) {
        if (stack.isEmpty()) {
            return NONE;
        }
        Item item = stack.getItem();
        if (item instanceof IElementTypeProvider) {
            IElementTypeProvider provider = (IElementTypeProvider)item;
            return provider.getElementType();
        }
        return NONE;
    }

    public static <T> RecordCodecBuilder<T, ElementType> forGetter(Function<T, ElementType> getter) {
        return CODEC.fieldOf("element_type").forGetter(getter);
    }

    static {
        ALL_VALID = ImmutableList.copyOf(Stream.of(ElementType.values()).filter(type -> type != NONE).toList());
        CODEC = StringRepresentable.fromEnum(ElementType::values);
        STREAM_CODEC = ByteBufCodecs.INT.map(i -> ElementType.values()[i], Enum::ordinal);
    }
}

