/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.advancements;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.advancements.ECCriteriaTriggers;
import sirttas.elementalcraft.advancements.LookAtSourceTrigger;
import sirttas.elementalcraft.data.attachment.ECDataAttachments;
import sirttas.elementalcraft.network.payload.PayloadHelper;
import sirttas.elementalcraft.tag.ECTags;

public record LookAtSourcePayload(BlockHitResult hitResult) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LookAtSourcePayload> TYPE = PayloadHelper.createType("look_at_source");
    public static final StreamCodec<FriendlyByteBuf, LookAtSourcePayload> STREAM_CODEC = StreamCodec.of((b, p) -> p.write((FriendlyByteBuf)b), LookAtSourcePayload::new);

    public LookAtSourcePayload(FriendlyByteBuf buf) {
        this(buf.readBlockHitResult());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockHitResult(this.hitResult);
    }

    @NotNull
    public CustomPacketPayload.Type<LookAtSourcePayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext payloadContext) {
        payloadContext.enqueueWork(() -> {
            ServerPlayer player;
            Level level;
            BlockState state;
            Player patt0$temp = payloadContext.player();
            if (patt0$temp instanceof ServerPlayer && (state = (level = (player = (ServerPlayer)patt0$temp).level()).getBlockState(this.hitResult.getBlockPos())).is(ECTags.Blocks.SOURCES)) {
                ((LookAtSourceTrigger)((Object)((Object)ECCriteriaTriggers.LOOK_AT_SOURCE.get()))).trigger(player);
                player.setData(ECDataAttachments.HAS_SEEN_SOURCE, (Object)true);
            }
        });
    }
}

