/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.events;

import invtweaks.config.InvTweaksConfig;
import invtweaks.util.ClientUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="invtweaks")
public class ServerEvents {
    private static final Map<Player, EnumMap<InteractionHand, Item>> itemsCache = new WeakHashMap<Player, EnumMap<InteractionHand, Item>>();
    private static final Map<Player, Object2IntMap<Item>> usedCache = new WeakHashMap<Player, Object2IntMap<Item>>();

    private ServerEvents() {
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (!event.getEntity().level().isClientSide) {
            if (!InvTweaksConfig.getPlayerAutoRefill(event.getEntity())) {
                return;
            }
            EnumMap cached = itemsCache.computeIfAbsent(event.getEntity(), k -> new EnumMap(InteractionHand.class));
            Object2IntMap ucached = usedCache.computeIfAbsent(event.getEntity(), k -> new Object2IntOpenHashMap());
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack held;
                if (cached.get(hand) != null && event.getEntity().getItemInHand(hand).isEmpty() && ((ServerPlayer)event.getEntity()).getStats().getValue(Stats.ITEM_USED.get((Object)((Item)cached.get(hand)))) > ucached.getOrDefault(cached.get(hand), Integer.MAX_VALUE)) {
                    ServerEvents.searchForSubstitute(event.getEntity(), hand, (Item)cached.get(hand));
                }
                cached.put(hand, (held = event.getEntity().getItemInHand(hand)).isEmpty() ? null : held.getItem());
                if (held.isEmpty()) continue;
                ucached.put((Object)held.getItem(), ((ServerPlayer)event.getEntity()).getStats().getValue(Stats.ITEM_USED.get((Object)held.getItem())));
            }
        } else if (InvTweaksConfig.isDirty()) {
            if (ClientUtils.serverConnectionExists()) {
                PacketDistributor.sendToServer((CustomPacketPayload)InvTweaksConfig.getSyncPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            InvTweaksConfig.setDirty(false);
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide && event.getEntity() == ClientUtils.safeGetPlayer()) {
            InvTweaksConfig.setDirty(true);
        }
    }

    private static void searchForSubstitute(Player ent, InteractionHand hand, Item item) {
        IntList frozen = (IntList)Optional.ofNullable(InvTweaksConfig.getPlayerRules(ent).catToInventorySlots("/FROZEN")).map(IntArrayList::new).orElseGet(IntArrayList::new);
        frozen.sort(null);
        if (Collections.binarySearch(frozen, ent.getInventory().selected) >= 0) {
            return;
        }
        IItemHandler cap = (IItemHandler)ent.getCapability(Capabilities.ItemHandler.ENTITY);
        if (cap != null) {
            TagKey altTag = null;
            if (item instanceof TieredItem) {
                if (item instanceof SwordItem) {
                    altTag = ItemTags.SWORDS;
                } else if (item instanceof PickaxeItem) {
                    altTag = ItemTags.PICKAXES;
                } else if (item instanceof AxeItem) {
                    altTag = ItemTags.AXES;
                } else if (item instanceof ShovelItem) {
                    altTag = ItemTags.SHOVELS;
                } else if (item instanceof HoeItem) {
                    altTag = ItemTags.HOES;
                }
            }
            TagKey finalAltTag = altTag;
            int alternativeSlot = -1;
            for (int i = 0; i < cap.getSlots(); ++i) {
                if (Collections.binarySearch(frozen, i) >= 0 || i >= 36 && i <= 39) continue;
                ItemStack candidate = cap.extractItem(i, Integer.MAX_VALUE, true).copy();
                if (candidate.is(item)) {
                    cap.extractItem(i, Integer.MAX_VALUE, false);
                    ent.setItemInHand(hand, candidate);
                    break;
                }
                if (finalAltTag == null || !candidate.is(finalAltTag)) continue;
                alternativeSlot = i;
            }
            if (alternativeSlot >= 0 && ent.getItemInHand(hand).isEmpty()) {
                ent.setItemInHand(hand, cap.extractItem(alternativeSlot, Integer.MAX_VALUE, false));
            }
        }
    }
}

