/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.ring_of_attraction;

import com.kwpugh.ring_of_attraction.Config;
import com.kwpugh.ring_of_attraction.EnableUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class PlayerSpecialAbilities {
    public static void doAttraction(Level level, Player player, ItemStack stack) {
        int range = Config.pullRange;
        int ringAttractionBlocking = Config.blockingDistance;
        boolean ringAttractionMode = Config.instantMode;
        if (!level.isClientSide && EnableUtil.isEnabled(stack)) {
            double x = player.getX();
            double y = player.getY();
            double z = player.getZ();
            BlockPos playerPos = new BlockPos((Vec3i)player.getOnPos());
            for (Object targetPos : BlockPos.betweenClosed((BlockPos)playerPos.offset(-range, -ringAttractionBlocking, -range), (BlockPos)playerPos.offset(range, ringAttractionBlocking, range))) {
                BlockState blockstate = level.getBlockState((BlockPos)targetPos);
                if (blockstate.getBlock() != Blocks.COAL_BLOCK) continue;
                return;
            }
            List items = player.level().getEntitiesOfClass(ItemEntity.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
            for (ItemEntity e : items) {
                if (player.isShiftKeyDown() || e.getPersistentData().getBoolean("PreventRemoteMovement")) continue;
                if (ringAttractionMode) {
                    e.playerTouch(player);
                    continue;
                }
                double factor = 0.035;
                e.push((x - e.getX()) * factor, (y - e.getY() + 1.25) * factor, (z - e.getZ()) * factor);
            }
            List xp = player.level().getEntitiesOfClass(ExperienceOrb.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
            for (ExperienceOrb orb : xp) {
                if (player.isShiftKeyDown()) continue;
                if (ringAttractionMode) {
                    orb.playerTouch(player);
                    continue;
                }
                double factor = 0.035;
                orb.push((x - orb.getX()) * factor, (y - orb.getY() + 1.25) * factor, (z - orb.getZ()) * factor);
            }
        }
    }
}

