/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.ring_of_attraction;

import com.kwpugh.ring_of_attraction.Config;
import com.kwpugh.ring_of_attraction.EnableUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemRingAttraction
extends Item {
    public ItemRingAttraction(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && !player.isCrouching()) {
            EnableUtil.changeStatus(stack);
            player.displayClientMessage((Component)Component.translatable((String)"item.ring_of_attraction.ring_attraction.line5").withStyle(ChatFormatting.WHITE), true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
        }
        return super.use(world, player, hand);
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return EnableUtil.isEnabled(stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.ring_of_attraction.ring_attraction.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.ring_of_attraction.ring_attraction.line2").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.ring_of_attraction.ring_attraction.line3").withStyle(ChatFormatting.YELLOW));
        if (Config.worksInEnderchest) {
            tooltip.add((Component)Component.translatable((String)"item.ring_of_attraction.ring_attraction.line7").withStyle(ChatFormatting.BLUE));
        }
        tooltip.add((Component)Component.translatable((String)"item.ring_of_attraction.ring_attraction.line4").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.ring_of_attraction.ring_attraction.line5").withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.ring_of_attraction.ring_attraction.line6", (Object[])new Object[]{Config.pullRange}).withStyle(ChatFormatting.BLUE));
    }
}

