/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.events;

import dev.xkmc.l2library.content.explosion.BaseExplosion;
import dev.xkmc.l2library.content.raytrace.RayTraceUtil;
import dev.xkmc.l2library.util.PlayerTracker;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="l2library", bus=EventBusSubscriber.Bus.GAME)
public class MiscServerEventHandler {
    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Post event) {
        RayTraceUtil.serverTick(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        if (event.getEntity().tickCount < 5) {
            PlayerTracker.get(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onDetonate(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        if (explosion instanceof BaseExplosion) {
            BaseExplosion exp = (BaseExplosion)explosion;
            event.getAffectedEntities().removeIf(e -> !exp.hurtEntity((Entity)e));
        }
    }

    @SubscribeEvent
    public static void onEntityStruck(EntityStruckByLightningEvent event) {
        if (event.getLightning().getTags().contains("l2library:safe_lightning") && (!(event.getEntity() instanceof LivingEntity) || event.getEntity() == event.getLightning().getCause())) {
            event.setCanceled(true);
        }
    }
}

