/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.content.explosion;

import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public record VanillaExplosionContext(@Nullable Entity entity, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator calculator, boolean fire, Explosion.BlockInteraction type) {
    public VanillaExplosionContext(Level level, @Nullable Entity entity, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator calculator, boolean fire, Level.ExplosionInteraction type) {
        this(entity, source, calculator, fire, VanillaExplosionContext.getType(level, entity, type));
    }

    private static Explosion.BlockInteraction getType(Level level, @Nullable Entity entity, Level.ExplosionInteraction type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> level.getDestroyType(GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY);
            case Level.ExplosionInteraction.MOB -> {
                LivingEntity le;
                if (EventHooks.canEntityGrief((Level)level, entity instanceof LivingEntity ? (le = (LivingEntity)entity) : null)) {
                    yield level.getDestroyType(GameRules.RULE_MOB_EXPLOSION_DROP_DECAY);
                }
                yield Explosion.BlockInteraction.KEEP;
            }
            case Level.ExplosionInteraction.TNT -> level.getDestroyType(GameRules.RULE_TNT_EXPLOSION_DROP_DECAY);
            case Level.ExplosionInteraction.TRIGGER -> Explosion.BlockInteraction.TRIGGER_BLOCK;
        };
    }
}

