/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.content.explosion;

import dev.xkmc.l2library.content.explosion.BaseExplosion;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ExplosionHandler {
    public static void explode(BaseExplosion exp) {
        boolean flag;
        if (exp.base.level().isClientSide()) {
            return;
        }
        if (EventHooks.onExplosionStart((Level)exp.base.level(), (Explosion)exp)) {
            return;
        }
        exp.explode();
        Level level = exp.base.level();
        exp.finalizeExplosion(level.isClientSide());
        double x = exp.base.x();
        double y = exp.base.y();
        double z = exp.base.z();
        float r = exp.base.r();
        boolean bl = flag = exp.mc.type() == Explosion.BlockInteraction.KEEP;
        if (flag) {
            exp.clearToBlow();
        }
        for (Player player : level.players()) {
            ServerPlayer serverplayer;
            if (!(player instanceof ServerPlayer) || !((serverplayer = (ServerPlayer)player).distanceToSqr(x, y, z) < 4096.0)) continue;
            serverplayer.connection.send((Packet)new ClientboundExplodePacket(x, y, z, r, exp.getToBlow(), (Vec3)exp.getHitPlayers().get(serverplayer), exp.mc.type(), exp.particle.small(), exp.particle.large(), exp.particle.sound()));
        }
    }
}

