/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.init.data.world;

import dev.xkmc.glimmeringtales.content.block.crop.AbstractPopFruit;
import dev.xkmc.glimmeringtales.init.data.world.FeaturePlacement;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class PopPlacement
extends FeaturePlacement {
    protected final Supplier<AbstractPopFruit> block;
    protected final int rarity;
    protected final int count;

    public PopPlacement(String id, Supplier<AbstractPopFruit> block, int rarity, int count) {
        super(id);
        this.block = block;
        this.rarity = rarity;
        this.count = count;
    }

    public BlockPredicate getSpawnLocation() {
        return BlockPredicate.allOf((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.AIR}), (BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.GRASS_BLOCK}));
    }

    public PlacementModifier location() {
        return PlacementUtils.HEIGHTMAP;
    }

    @Override
    public void feature(BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
        RandomizedIntStateProvider state = new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)this.block.get())), this.block.get().getAgeProperty(), (IntProvider)UniformInt.of((int)1, (int)3));
        ctx.register(this.featureKey, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)new RandomPatchConfiguration(this.count, 4, 3, PlacementUtils.filtered((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)state), (BlockPredicate)this.getSpawnLocation()))));
    }

    @Override
    public void placed(BootstrapContext<PlacedFeature> ctx) {
        Holder.Reference feature = ctx.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(this.featureKey);
        ctx.register(this.placeKey, (Object)new PlacedFeature((Holder)feature, List.of(RarityFilter.onAverageOnceEvery((int)this.rarity), InSquarePlacement.spread(), this.location(), BiomeFilter.biome())));
    }
}

