/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.init.data.world;

import dev.xkmc.glimmeringtales.init.GlimmeringTales;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public abstract class Placement {
    private final String id;
    public final ResourceKey<PlacedFeature> placeKey;
    public final TagKey<Biome> biomeTag;

    public Placement(String id) {
        this.id = id;
        this.placeKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)GlimmeringTales.loc(id));
        this.biomeTag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)GlimmeringTales.loc("has_feature/" + id));
    }

    public void biome(BootstrapContext<BiomeModifier> ctx) {
        HolderGetter biomes = ctx.lookup(Registries.BIOME);
        HolderGetter features = ctx.lookup(Registries.PLACED_FEATURE);
        HolderSet.Named set = biomes.getOrThrow(this.biomeTag);
        ctx.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)GlimmeringTales.loc(this.id)), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)set, (HolderSet)HolderSet.direct((Holder[])new Holder[]{features.getOrThrow(this.placeKey)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }
}

