/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.init.data.world;

import com.tterrag.registrate.providers.DataProviderInitializer;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import dev.xkmc.glimmeringtales.init.GlimmeringTales;
import dev.xkmc.glimmeringtales.init.data.world.FeaturePlacement;
import dev.xkmc.glimmeringtales.init.data.world.LargeTreePlacement;
import dev.xkmc.glimmeringtales.init.data.world.PopPlacement;
import dev.xkmc.glimmeringtales.init.data.world.TreePlacement;
import dev.xkmc.glimmeringtales.init.data.world.WaterPopPlacement;
import dev.xkmc.glimmeringtales.init.reg.GTItems;
import dev.xkmc.glimmeringtales.init.reg.PopFruitType;
import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class GTWorldGen {
    public static final ResourceKey<ConfiguredFeature<?, ?>> CF_TREE = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)GlimmeringTales.loc("struck_tree"));
    private static final TreePlacement PF_SPARSE = new TreePlacement("struck_tree_sparse", 40, () -> GTItems.STRUCK_SAPLING.get());
    private static final TreePlacement PF_COMMON = new TreePlacement("struck_tree_common", 16, () -> GTItems.STRUCK_SAPLING.get());
    private static final TreePlacement PF_DENSE = new TreePlacement("struck_tree_dense", 8, () -> GTItems.STRUCK_SAPLING.get());
    private static final FeaturePlacement LARGE = new LargeTreePlacement("struck_large_tree");
    private static final FeaturePlacement POP = new PopPlacement("pop_fruit", PopFruitType.POP_FRUIT::get, 4, 64);
    private static final FeaturePlacement BLOSSOM_POP = new PopPlacement("blossom_pop_fruit", PopFruitType.BLOSSOM_POP_FRUIT::get, 1, 32);
    private static final FeaturePlacement OCEAN_POP = new WaterPopPlacement("ocean_pop_fruit", PopFruitType.OCEAN_POP_FRUIT::get, 8, 48);

    public static void genFeatures(DataProviderInitializer init) {
        init.add(Registries.CONFIGURED_FEATURE, ctx -> {
            ctx.register(CF_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)GTItems.STRUCK_LOG.getDefaultState()), (TrunkPlacer)new StraightTrunkPlacer(5, 2, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)GTItems.STRUCK_LEAVES.getDefaultState()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).ignoreVines().build()));
            LARGE.feature(ctx);
            POP.feature(ctx);
            BLOSSOM_POP.feature(ctx);
            OCEAN_POP.feature(ctx);
        });
        init.add(Registries.PLACED_FEATURE, ctx -> {
            Holder.Reference cf = ctx.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(CF_TREE);
            PF_SPARSE.placed((BootstrapContext<PlacedFeature>)ctx, (Holder<ConfiguredFeature<?, ?>>)cf);
            PF_COMMON.placed((BootstrapContext<PlacedFeature>)ctx, (Holder<ConfiguredFeature<?, ?>>)cf);
            PF_DENSE.placed((BootstrapContext<PlacedFeature>)ctx, (Holder<ConfiguredFeature<?, ?>>)cf);
            LARGE.placed((BootstrapContext<PlacedFeature>)ctx);
            POP.placed((BootstrapContext<PlacedFeature>)ctx);
            BLOSSOM_POP.placed((BootstrapContext<PlacedFeature>)ctx);
            OCEAN_POP.placed((BootstrapContext<PlacedFeature>)ctx);
        });
        init.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, ctx -> {
            PF_SPARSE.biome((BootstrapContext<BiomeModifier>)ctx);
            PF_COMMON.biome((BootstrapContext<BiomeModifier>)ctx);
            PF_DENSE.biome((BootstrapContext<BiomeModifier>)ctx);
            LARGE.biome((BootstrapContext<BiomeModifier>)ctx);
            POP.biome((BootstrapContext<BiomeModifier>)ctx);
            BLOSSOM_POP.biome((BootstrapContext<BiomeModifier>)ctx);
            OCEAN_POP.biome((BootstrapContext<BiomeModifier>)ctx);
        });
    }

    public static void genBiomeTags(RegistrateTagsProvider.Impl<Biome> pvd) {
        pvd.addTag(GTWorldGen.PF_SPARSE.biomeTag).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SNOWY_PLAINS, Biomes.GROVE, Biomes.TAIGA, Biomes.SNOWY_TAIGA}).addTag(Tags.Biomes.IS_PLAINS);
        pvd.addTag(GTWorldGen.PF_COMMON.biomeTag).add(new ResourceKey[]{Biomes.SWAMP, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_FOREST}).addTag(Tags.Biomes.IS_FOREST);
        pvd.addTag(GTWorldGen.PF_DENSE.biomeTag).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.DARK_FOREST}).addTag(Tags.Biomes.IS_JUNGLE);
        pvd.addTag(GTWorldGen.LARGE.biomeTag).add(Biomes.JUNGLE).addTag(Tags.Biomes.IS_JUNGLE);
        pvd.addTag(GTWorldGen.POP.biomeTag).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SNOWY_PLAINS, Biomes.GROVE, Biomes.TAIGA, Biomes.SNOWY_TAIGA}).addTag(Tags.Biomes.IS_PLAINS);
        pvd.addTag(GTWorldGen.BLOSSOM_POP.biomeTag).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.SUNFLOWER_PLAINS, Biomes.CHERRY_GROVE, Biomes.MEADOW}).addTag(Tags.Biomes.IS_FLORAL);
        pvd.addTag(GTWorldGen.OCEAN_POP.biomeTag).add(Biomes.DEEP_OCEAN).addTag(Tags.Biomes.IS_OCEAN);
    }
}

