/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.init.data.spell;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import dev.xkmc.glimmeringtales.content.core.description.SpellTooltip;
import dev.xkmc.glimmeringtales.content.core.description.SpellTooltipData;
import dev.xkmc.glimmeringtales.content.core.spell.BlockSpell;
import dev.xkmc.glimmeringtales.content.core.spell.NatureSpell;
import dev.xkmc.glimmeringtales.content.core.spell.ResearchBonus;
import dev.xkmc.glimmeringtales.content.core.spell.RuneBlock;
import dev.xkmc.glimmeringtales.content.core.spell.SpellElement;
import dev.xkmc.glimmeringtales.content.entity.hostile.MobCastingData;
import dev.xkmc.glimmeringtales.content.research.core.HexGraphData;
import dev.xkmc.glimmeringtales.content.research.core.ResearchDependency;
import dev.xkmc.glimmeringtales.init.GlimmeringTales;
import dev.xkmc.glimmeringtales.init.data.GTDamageTypeGen;
import dev.xkmc.glimmeringtales.init.data.GTTagGen;
import dev.xkmc.glimmeringtales.init.data.spell.NatureSpellEntry;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import dev.xkmc.l2core.util.MathHelper;
import dev.xkmc.l2magic.content.engine.context.DataGenContext;
import dev.xkmc.l2magic.content.engine.core.ConfiguredEngine;
import dev.xkmc.l2magic.content.engine.core.IPredicate;
import dev.xkmc.l2magic.content.engine.core.Verifiable;
import dev.xkmc.l2magic.content.engine.spell.SpellAction;
import dev.xkmc.l2magic.content.engine.spell.SpellCastType;
import dev.xkmc.l2magic.content.engine.spell.SpellTriggerType;
import dev.xkmc.l2magic.content.entity.core.ProjectileConfig;
import dev.xkmc.l2magic.init.data.DataGenCachedHolder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;

public class NatureSpellBuilder
extends NatureSpellEntry {
    private static int order = 1000;
    private final ResourceLocation id;
    private final GTRegistries.ElemEntry elem;
    public DataGenCachedHolder<ProjectileConfig> proj;
    public DataGenCachedHolder<SpellAction> spell;
    public DataGenCachedHolder<NatureSpell> nature;
    public DataGenCachedHolder<HexGraphData> graph;
    public ResourceKey<DamageType> damage;
    private Function<NatureSpellBuilder, ProjectileConfig> projectileFactory;
    private Function<NatureSpellBuilder, SpellAction> spellFactory;
    private Function<Holder<SpellAction>, NatureSpell> natureFactory;
    private Function<ResourceLocation, String> langFactory;
    private Function<Holder<NatureSpell>, RuneBlock> runeFactory;
    private Supplier<HexGraphData> graphFactory;
    private SpellDamageEntry damageEntry;
    private SpellDesc desc;
    private ItemLike icon;
    private MobCastingData mob;
    private boolean grounded;
    private DataGenContext cache;
    private final List<BiConsumer<BlockSpellBuilder, Holder<NatureSpell>>> blockFactories = new ArrayList<BiConsumer<BlockSpellBuilder, Holder<NatureSpell>>>();

    private static int getOrder() {
        return order++;
    }

    public NatureSpellBuilder(ResourceLocation id, GTRegistries.ElemEntry elem) {
        this.id = id;
        this.elem = elem;
    }

    public final NatureSpellBuilder damageFreeze() {
        return this.damageVanilla(() -> new DamageType("freeze", 0.0f, DamageEffects.FREEZING), GTDamageTypeGen.freeze(new TagKey[0]));
    }

    public final NatureSpellBuilder damageFire() {
        return this.damageVanilla(() -> new DamageType("onFire", 0.0f, DamageEffects.BURNING), DamageTypeTags.IS_FIRE);
    }

    public final NatureSpellBuilder damageExplosion() {
        return this.damageVanilla(() -> new DamageType("explosion", 0.1f), DamageTypeTags.IS_EXPLOSION);
    }

    @SafeVarargs
    public final NatureSpellBuilder damageVanilla(Supplier<DamageType> def, TagKey<DamageType> ... tags) {
        this.damage = NatureSpellBuilder.damage(this.id);
        this.damageEntry = new SpellDamageEntry(msg -> (DamageType)def.get(), null, null, (TagKey[])MathHelper.merge((Object[])tags, (Object[])new TagKey[]{this.elem.damgeTag()}));
        return this;
    }

    @SafeVarargs
    public final NatureSpellBuilder damageCustom(Function<String, DamageType> def, String noPlayer, String withPlayer, TagKey<DamageType> ... tags) {
        this.damage = NatureSpellBuilder.damage(this.id);
        this.damageEntry = new SpellDamageEntry(def, noPlayer, withPlayer, (TagKey[])MathHelper.merge((Object[])tags, (Object[])new TagKey[]{this.elem.damgeTag()}));
        return this;
    }

    public NatureSpellBuilder projectile(Function<NatureSpellBuilder, ProjectileConfig> factory) {
        this.proj = NatureSpellBuilder.projectile(this.id);
        this.projectileFactory = factory;
        return this;
    }

    public NatureSpellBuilder spell(Function<NatureSpellBuilder, ConfiguredEngine<?>> factory, ItemLike icon, SpellCastType cast, SpellTriggerType trigger) {
        this.spell = NatureSpellBuilder.spell(this.id);
        this.icon = icon;
        this.spellFactory = e -> new SpellAction((ConfiguredEngine)factory.apply((NatureSpellBuilder)((Object)e)), icon.asItem(), NatureSpellBuilder.getOrder(), cast, trigger);
        return this;
    }

    public NatureSpellBuilder spell(Function<NatureSpellBuilder, ConfiguredEngine<?>> factory, ItemLike icon, SpellCastType cast, SpellTriggerType trigger, Function<NatureSpellBuilder, IPredicate> pred) {
        this.spell = NatureSpellBuilder.spell(this.id);
        this.icon = icon;
        this.spellFactory = e -> new SpellAction((ConfiguredEngine)factory.apply((NatureSpellBuilder)((Object)e)), icon.asItem(), NatureSpellBuilder.getOrder(), cast, trigger, (IPredicate)pred.apply((NatureSpellBuilder)((Object)e)));
        return this;
    }

    @Deprecated(forRemoval=true)
    public NatureSpellBuilder cost(int cost) {
        return this.cost(cost, 0);
    }

    @Deprecated(forRemoval=true)
    public NatureSpellBuilder cost(int cost, int max) {
        return this.focusAndCost(10, cost, max);
    }

    public NatureSpellBuilder focusAndCost(int focus, int cost) {
        return this.focusAndCost(focus, cost, 0);
    }

    public NatureSpellBuilder focusAndCost(int focus, int cost, int max) {
        this.nature = NatureSpellBuilder.nature(this.id);
        this.natureFactory = e -> new NatureSpell((Holder<SpellAction>)e, this.elem.get(), focus, cost, max, this.desc == null ? this.warnEmpty() : this.desc.data, this.mob, (Holder<HexGraphData>)this.graph);
        return this;
    }

    public NatureSpellBuilder mob(int range, double factor, int maxTime, int delay) {
        this.mob = new MobCastingData(range, maxTime, factor, delay);
        return this;
    }

    @SafeVarargs
    public final NatureSpellBuilder block(Function<NatureSpellBuilder, ConfiguredEngine<?>> action, ItemLike icon, Function<Holder<NatureSpell>, RuneBlock> item, BiConsumer<BlockSpellBuilder, Holder<NatureSpell>> ... cons) {
        this.spell = NatureSpellBuilder.spell(this.id);
        this.icon = icon;
        this.spellFactory = ctx -> NatureSpellBuilder.ofBlock((ConfiguredEngine)action.apply((NatureSpellBuilder)((Object)ctx)), icon, NatureSpellBuilder.getOrder());
        this.runeFactory = item;
        this.blockFactories.addAll(List.of(cons));
        return this;
    }

    @SafeVarargs
    public final NatureSpellBuilder block(Function<NatureSpellBuilder, ConfiguredEngine<?>> action, Function<NatureSpellBuilder, IPredicate> cond, ItemLike icon, Function<Holder<NatureSpell>, RuneBlock> item, BiConsumer<BlockSpellBuilder, Holder<NatureSpell>> ... cons) {
        this.spell = NatureSpellBuilder.spell(this.id);
        this.icon = icon;
        this.spellFactory = ctx -> NatureSpellBuilder.ofBlock((ConfiguredEngine)action.apply((NatureSpellBuilder)((Object)ctx)), (IPredicate)cond.apply((NatureSpellBuilder)((Object)ctx)), icon, NatureSpellBuilder.getOrder());
        this.runeFactory = item;
        this.blockFactories.addAll(List.of(cons));
        return this;
    }

    public NatureSpellBuilder graph(NatureSpellBuilder other) {
        this.graph = other.graph;
        return this;
    }

    public NatureSpellBuilder graph(@Nullable ResearchDependency dep, ArrayList<ResearchBonus> bonus, String ... strs) {
        this.graph = NatureSpellBuilder.graph(this.id);
        int prev = Integer.MAX_VALUE;
        for (ResearchBonus e : bonus) {
            if (e.cost() > prev) {
                throw new IllegalArgumentException("Illegal cost for " + String.valueOf(this.id));
            }
            prev = e.cost();
        }
        this.graphFactory = () -> {
            LinkedHashMap<String, SpellElement> map = new LinkedHashMap<String, SpellElement>();
            for (String s : strs) {
                block10: for (int i = 0; i < s.length(); ++i) {
                    char ch = s.charAt(i);
                    switch (ch) {
                        case 'L': {
                            map.put("L", GTRegistries.LIFE.get());
                            continue block10;
                        }
                        case 'E': {
                            map.put("E", GTRegistries.EARTH.get());
                            continue block10;
                        }
                        case 'F': {
                            map.put("F", GTRegistries.FLAME.get());
                            continue block10;
                        }
                        case 'S': {
                            map.put("S", GTRegistries.SNOW.get());
                            continue block10;
                        }
                        case 'O': {
                            map.put("O", GTRegistries.OCEAN.get());
                            continue block10;
                        }
                        case 'T': {
                            map.put("T", GTRegistries.THUNDER.get());
                            continue block10;
                        }
                        case '-': 
                        case '<': 
                        case '>': 
                        case '|': {
                            continue block10;
                        }
                        default: {
                            throw new IllegalArgumentException("Char %c is illegal in flow %s for spell %s".formatted(Character.valueOf(ch), s, this.id));
                        }
                    }
                }
            }
            return new HexGraphData(this.icon.asItem(), dep, map, new ArrayList<String>(List.of(strs)), bonus);
        };
        return this;
    }

    public ResearchDependency asParent(ResearchDependency.Type type) {
        return new ResearchDependency((Holder<HexGraphData>)this.graph, type);
    }

    public NatureSpellBuilder lang(String name) {
        return this.lang((ResourceLocation e) -> name);
    }

    public NatureSpellBuilder lang(Function<ResourceLocation, String> factory) {
        this.langFactory = factory;
        return this;
    }

    public NatureSpellBuilder desc(String brief, String detail, SpellTooltipData data) {
        this.desc = new SpellDesc(brief, detail, data);
        return this;
    }

    public NatureSpellBuilder grounded() {
        this.grounded = true;
        return this;
    }

    public Holder<DamageType> damage() {
        return this.cache.damage(this.damage);
    }

    @Override
    public void regNature(BootstrapContext<NatureSpell> ctx) {
        SpellTriggerType trigger;
        this.cache = new DataGenContext(ctx);
        this.nature.gen(ctx, (Object)this.natureFactory.apply((Holder<SpellAction>)this.spell));
        this.cache = null;
        try {
            new SpellTooltip((Verifiable)((SpellAction)((NatureSpell)this.nature.value()).spell().value()).action(), this.desc.data).verify();
        }
        catch (Exception e) {
            GlimmeringTales.LOGGER.error("Spell {} failed description check", (Object)this.id);
            GlimmeringTales.LOGGER.throwing((Throwable)e);
        }
        if (((NatureSpell)this.nature.value).mob() == null && ((trigger = ((SpellAction)((NatureSpell)this.nature.value).spell().value()).triggerType()) == SpellTriggerType.TARGET_ENTITY || trigger == SpellTriggerType.TARGET_POS)) {
            GlimmeringTales.LOGGER.warn("Spell {} is not available for mobs to cast", (Object)this.id);
        }
    }

    @Override
    public void regBlock(DataMapProvider.Builder<BlockSpell, Block> builder) {
        BlockSpellBuilder b = new BlockSpellBuilder(builder);
        for (BiConsumer<BlockSpellBuilder, Holder<NatureSpell>> e : this.blockFactories) {
            e.accept(b, (Holder<NatureSpell>)this.nature);
        }
    }

    @Override
    public void regRune(DataMapProvider.Builder<RuneBlock, Item> item) {
        if (this.runeFactory != null) {
            item.add((Holder)this.icon.asItem().builtInRegistryHolder(), (Object)this.runeFactory.apply((Holder<NatureSpell>)this.nature), false, new ICondition[0]);
        }
    }

    @Override
    public void regGraph(BootstrapContext<HexGraphData> ctx) {
        if (this.graphFactory == null) {
            return;
        }
        ctx.register(this.graph.key, (Object)this.graphFactory.get());
    }

    public void register(BootstrapContext<SpellAction> ctx) {
        this.cache = new DataGenContext(ctx);
        this.spellFactory.apply(this).verifyOnBuild(ctx, this.spell);
        this.cache = null;
    }

    public void genLang(RegistrateLangProvider pvd) {
        pvd.add(SpellAction.lang((ResourceLocation)this.id), this.langFactory.apply(this.id));
        if (this.damageEntry != null) {
            if (this.damageEntry.noPlayer != null) {
                pvd.add("death.attack." + this.id.toLanguageKey(), this.damageEntry.noPlayer);
            }
            if (this.damageEntry.withPlayer != null) {
                pvd.add("death.attack." + this.id.toLanguageKey() + ".player", this.damageEntry.withPlayer);
            }
        }
        if (this.desc != null) {
            pvd.add(SpellTooltipData.brief(this.id), this.desc.brief);
            pvd.add(SpellTooltipData.detail(this.id), this.desc.detail);
        }
    }

    @Override
    public void registerDamage(GTDamageTypeGen gen) {
        if (this.damageEntry != null) {
            gen.genDamage(this.damage, () -> this.damageEntry.def().apply(this.id.toLanguageKey()), this.damageEntry.tags());
        }
    }

    public void registerProjectile(BootstrapContext<ProjectileConfig> ctx) {
        if (this.projectileFactory != null && this.proj != null) {
            this.cache = new DataGenContext(ctx);
            this.projectileFactory.apply(this).verifyOnBuild(ctx, this.proj);
            this.cache = null;
        }
    }

    @Override
    public void regTag(RegistrateTagsProvider.Impl<NatureSpell> pvd) {
        if (this.grounded) {
            pvd.addTag(GTTagGen.GROUNDED).add(this.nature.key);
        }
    }

    private SpellTooltipData warnEmpty() {
        GlimmeringTales.LOGGER.error("Spell {} does not have description setup", (Object)this.id);
        return SpellTooltipData.of();
    }

    @Nullable
    private HexGraphData warnNoGraph() {
        GlimmeringTales.LOGGER.error("Spell {} does not have graph setup", (Object)this.id);
        return null;
    }

    public record SpellDamageEntry(Function<String, DamageType> def, @Nullable String noPlayer, @Nullable String withPlayer, TagKey<DamageType>[] tags) {
    }

    public record SpellDesc(String brief, String detail, SpellTooltipData data) {
    }

    public record BlockSpellBuilder(DataMapProvider.Builder<BlockSpell, Block> builder) {
        public void add(Block block, BlockSpell spell) {
            this.builder.add((Holder)block.builtInRegistryHolder(), (Object)spell, false, new ICondition[0]);
        }

        public void add(Holder<Block> block, BlockSpell spell) {
            this.builder.add(block, (Object)spell, false, new ICondition[0]);
        }

        public void add(TagKey<Block> block, BlockSpell spell) {
            this.builder.add(block, (Object)spell, false, new ICondition[0]);
        }
    }
}

