/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.init.data;

import com.tterrag.registrate.providers.RegistrateTagsProvider;
import dev.xkmc.glimmeringtales.content.core.spell.SpellElement;
import dev.xkmc.glimmeringtales.init.GlimmeringTales;
import dev.xkmc.glimmeringtales.init.data.GTDamageStates;
import dev.xkmc.glimmeringtales.init.data.spell.NatureSpellEntry;
import dev.xkmc.glimmeringtales.init.data.spell.NatureSpellGenRegistry;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2core.util.MathHelper;
import dev.xkmc.l2damagetracker.contents.damage.DamageState;
import dev.xkmc.l2damagetracker.contents.damage.DamageTypeRoot;
import dev.xkmc.l2damagetracker.contents.damage.DamageTypeWrapper;
import dev.xkmc.l2damagetracker.contents.damage.DefaultDamageState;
import dev.xkmc.l2damagetracker.init.data.DamageTypeAndTagsGen;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.neoforged.neoforge.common.Tags;

public class GTDamageTypeGen
extends DamageTypeAndTagsGen {
    public static final TagKey<DamageType> SPELL = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)GlimmeringTales.loc("spells"));
    public static final ResourceKey<DamageType> THUNDER = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)GlimmeringTales.loc("lightning"));
    public static final ResourceKey<DamageType> FALLING = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)GlimmeringTales.loc("falling_block"));
    protected final List<DamageTypeWrapper> list = new ArrayList<DamageTypeWrapper>();

    @SafeVarargs
    public static TagKey<DamageType>[] magic(TagKey<DamageType> ... tags) {
        return (TagKey[])MathHelper.merge((Object[])tags, (Object[])new TagKey[]{Tags.DamageTypes.IS_MAGIC, DamageTypeTags.BYPASSES_ARMOR});
    }

    @SafeVarargs
    public static TagKey<DamageType>[] freeze(TagKey<DamageType> ... tags) {
        return (TagKey[])MathHelper.merge((Object[])tags, (Object[])new TagKey[]{DamageTypeTags.IS_FREEZING, DamageTypeTags.NO_KNOCKBACK, DamageTypeTags.BYPASSES_ARMOR});
    }

    public GTDamageTypeGen(L2Registrate reg) {
        super(reg);
        this.genDamage(THUNDER, () -> new DamageType("lightningBolt", 0.1f), GTRegistries.THUNDER.damgeTag(), DamageTypeTags.IS_LIGHTNING, DamageTypeTags.NO_KNOCKBACK);
        this.genDamage(FALLING, () -> new DamageType("fallingBlock", 0.1f), GTRegistries.EARTH.damgeTag(), DamageTypeTags.DAMAGES_HELMET, Tags.DamageTypes.IS_PHYSICAL);
        for (NatureSpellEntry e : NatureSpellGenRegistry.LIST) {
            e.registerDamage(this);
        }
        DamageTypeRoot.configureGeneration(Set.of("l2damagetracker", "glimmeringtales"), (String)"glimmeringtales", this.list);
    }

    @SafeVarargs
    public final void genDamage(ResourceKey<DamageType> id, Supplier<DamageType> def, TagKey<DamageType> ... tags) {
        DamageTypeRoot root = new DamageTypeRoot("glimmeringtales", id, List.of(tags), type -> (DamageType)def.get());
        new DamageTypeAndTagsGen.DamageTypeHolder((DamageTypeAndTagsGen)this, id, def.get()).add(tags);
        root.add((DamageState)DefaultDamageState.BYPASS_MAGIC);
        root.add((DamageState)DefaultDamageState.BYPASS_COOLDOWN);
        root.add((DamageState)GTDamageStates.MAGIC);
    }

    protected void addDamageTypes(BootstrapContext<DamageType> ctx) {
        super.addDamageTypes(ctx);
        DamageTypeRoot.generateAll();
        for (DamageTypeWrapper wrapper : this.list) {
            ctx.register(wrapper.type(), (Object)wrapper.getObject());
        }
    }

    protected void addDamageTypeTags(RegistrateTagsProvider.Impl<DamageType> pvd) {
        super.addDamageTypeTags(pvd);
        DamageTypeRoot.generateAll();
        for (DamageTypeWrapper wrapper : this.list) {
            wrapper.gen(arg_0 -> pvd.addTag(arg_0));
        }
        TagsProvider.TagAppender spell = pvd.addTag(SPELL);
        for (SpellElement e : GTRegistries.ELEMENT.reg()) {
            pvd.addTag(e.damgeTag());
            spell.addTag(e.damgeTag());
        }
    }
}

