/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.init.data;

import dev.xkmc.glimmeringtales.init.GlimmeringTales;
import dev.xkmc.l2core.util.ConfigInit;
import net.neoforged.neoforge.common.ModConfigSpec;

public class GTConfigs {
    public static final Client CLIENT = (Client)GlimmeringTales.REGISTRATE.registerClient(Client::new);
    public static final Server SERVER = (Server)GlimmeringTales.REGISTRATE.registerSynced(Server::new);

    public static class Client
    extends ConfigInit {
        public final ModConfigSpec.IntValue resonatorSearchRadius;
        public final ModConfigSpec.IntValue resonatorSearchTrialsPerTick;

        public Client(ConfigInit.Builder builder) {
            this.markL2();
            builder.push("resonator", "Resonator properties");
            this.resonatorSearchRadius = builder.text("Amethyst Resonator search radius").defineInRange("resonatorSearchRadius", 64, 16, 128);
            this.resonatorSearchTrialsPerTick = builder.text("Amethyst Resonator search trials per tick").defineInRange("resonatorSearchTrialsPerTick", 500, 16, 10000);
            builder.pop();
        }
    }

    public static class Server
    extends ConfigInit {
        public final ModConfigSpec.IntValue crystalOfFlameRequirement;
        public final ModConfigSpec.IntValue crystalOfWinterstormRequirement;
        public final ModConfigSpec.IntValue wandInteractionDistance;
        public final ModConfigSpec.IntValue ritualRange;
        public final ModConfigSpec.DoubleValue playerCastingDelayFactor;
        public final ModConfigSpec.DoubleValue popFruitExplosionChanceOnEaten;
        public final ModConfigSpec.DoubleValue popFruitExplosionDamageFactor;
        public final ModConfigSpec.DoubleValue popFruitBonemealGrowChance;
        public final ModConfigSpec.IntValue popFruitNaturalGrowRarity;
        public final ModConfigSpec.IntValue popFruitBiomeGrowFactor;
        public final ModConfigSpec.IntValue popFruitAdjacentCrystalBoost;

        public Server(ConfigInit.Builder builder) {
            this.markL2();
            this.wandInteractionDistance = builder.text("Wand interaction range").defineInRange("wandInteractionDistance", 24, 4, 64);
            this.playerCastingDelayFactor = builder.text("Player Spell Casting Delay Factor").defineInRange("playerCastingDelayFactor", 0.0, 0.0, 2.0);
            this.ritualRange = builder.text("Range for ritual blocks to check for each other").defineInRange("ritualRange", 3, 1, 16);
            builder.push("materials", "Material properties");
            this.crystalOfFlameRequirement = builder.text("Crystal of Flame: Lava consumption").defineInRange("crystalOfFlameRequirement", 64, 1, 1000);
            this.crystalOfWinterstormRequirement = builder.text("Crystal of Winterstorm: Powder Snow consumption").defineInRange("crystalOfWinterstormRequirement", 64, 1, 1000);
            builder.pop();
            builder.push("pop_fruit", "Pop Fruit");
            this.popFruitExplosionChanceOnEaten = builder.text("Chance for Pop Fruit to explosion on consumed").defineInRange("popFruitExplosionChanceOnEaten", 0.1, 0.0, 1.0);
            this.popFruitExplosionDamageFactor = builder.text("Explosion damage factor for pop fruit").defineInRange("popFruitExplosionDamageFactor", 0.35, 0.0, 2.0);
            this.popFruitBonemealGrowChance = builder.text("Chance for Pop Fruit to grow on bone meal").defineInRange("popFruitBonemealGrowChance", 0.05, 0.0, 1.0);
            this.popFruitNaturalGrowRarity = builder.text("Pop Fruit has one in X chance to grow on random tick").defineInRange("popFruitNaturalGrowRarity", 100, 10, 1000);
            this.popFruitBiomeGrowFactor = builder.text("Pop Fruit growth speed multiplier in correct biome").defineInRange("popFruitBiomeGrowFactor", 3, 0, 100);
            this.popFruitAdjacentCrystalBoost = builder.text("Pop Fruit growth speed multiplier when there is adjacent crystal vine").defineInRange("popFruitAdjacentCrystalBoost", 1, 0, 10);
            builder.pop();
        }
    }
}

