/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.init;

import com.mojang.serialization.Codec;
import com.tterrag.registrate.providers.DataProviderInitializer;
import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.glimmeringtales.compat.apoth.ApothCompat;
import dev.xkmc.glimmeringtales.compat.golem.GolemCompat;
import dev.xkmc.glimmeringtales.compat.misc.PatchouliCompat;
import dev.xkmc.glimmeringtales.content.block.altar.BaseRitualBlockEntity;
import dev.xkmc.glimmeringtales.content.core.description.SpellTooltipRegistry;
import dev.xkmc.glimmeringtales.content.core.spell.NatureSpell;
import dev.xkmc.glimmeringtales.content.core.spell.SpellElement;
import dev.xkmc.glimmeringtales.content.research.core.GraphToServerPacket;
import dev.xkmc.glimmeringtales.content.research.core.HexGraphData;
import dev.xkmc.glimmeringtales.content.research.core.OpenGraphPacket;
import dev.xkmc.glimmeringtales.events.GTAttackListener;
import dev.xkmc.glimmeringtales.events.GTClickHandler;
import dev.xkmc.glimmeringtales.init.data.GTAdvGen;
import dev.xkmc.glimmeringtales.init.data.GTDamageTypeGen;
import dev.xkmc.glimmeringtales.init.data.GTDataMapGen;
import dev.xkmc.glimmeringtales.init.data.GTHostilityGen;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import dev.xkmc.glimmeringtales.init.data.GTParticleGen;
import dev.xkmc.glimmeringtales.init.data.GTRecipeGen;
import dev.xkmc.glimmeringtales.init.data.GTSlotGen;
import dev.xkmc.glimmeringtales.init.data.GTTagGen;
import dev.xkmc.glimmeringtales.init.data.spell.GTSpells;
import dev.xkmc.glimmeringtales.init.data.world.GTWorldGen;
import dev.xkmc.glimmeringtales.init.reg.GTEffects;
import dev.xkmc.glimmeringtales.init.reg.GTEngine;
import dev.xkmc.glimmeringtales.init.reg.GTEntities;
import dev.xkmc.glimmeringtales.init.reg.GTItems;
import dev.xkmc.glimmeringtales.init.reg.GTParticles;
import dev.xkmc.glimmeringtales.init.reg.GTRecipes;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import dev.xkmc.l2backpack.content.common.BaseBagItemHandler;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2core.init.reg.simple.Reg;
import dev.xkmc.l2core.serial.config.PacketHandlerWithConfig;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2magic.content.engine.core.ProcessorType;
import dev.xkmc.l2magic.content.engine.spell.SpellAction;
import dev.xkmc.l2magic.init.registrate.EngineRegistry;
import dev.xkmc.l2serial.network.PacketHandler;
import dev.xkmc.l2serial.serialization.codec.CodecAdaptor;
import dev.xkmc.l2serial.serialization.custom_handler.Handlers;
import dev.xkmc.l2serial.util.Wrappers;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="glimmeringtales")
@EventBusSubscriber(modid="glimmeringtales", bus=EventBusSubscriber.Bus.MOD)
public class GlimmeringTales {
    public static final String MODID = "glimmeringtales";
    public static final PacketHandlerWithConfig HANDLER = new PacketHandlerWithConfig("glimmeringtales", 1, new Function[]{e -> e.create(GraphToServerPacket.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(OpenGraphPacket.class, PacketHandler.NetDir.PLAY_TO_CLIENT)});
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Reg REG = new Reg("glimmeringtales");
    public static final L2Registrate REGISTRATE = new L2Registrate("glimmeringtales");
    public static GTDamageTypeGen DMG_GEN;

    public GlimmeringTales(IEventBus bus) {
        GTRegistries.register();
        GTItems.register();
        GTRecipes.register();
        GTEngine.register();
        GTEntities.register();
        GTEffects.register();
        GTParticles.register();
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.gen();
        }
        if (ModList.get().isLoaded("apotheosis")) {
            ApothCompat.register(bus);
        }
        DMG_GEN = new GTDamageTypeGen(REGISTRATE);
        new GTClickHandler(GlimmeringTales.loc("hex"));
    }

    private static void initHandlers() {
        Handlers.registerReg(NatureSpell.class, GTRegistries.SPELL);
        Handlers.registerReg(HexGraphData.class, GTRegistries.GRAPH);
        Handlers.registerReg(SpellAction.class, (ResourceKey)EngineRegistry.SPELL);
        Handlers.enableVanilla((Class)((Class)Wrappers.cast(ProcessorType.class)), (Registry)((Registry)EngineRegistry.PROCESSOR.registry().get()));
        SpellTooltipRegistry.init();
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            GlimmeringTales.initHandlers();
            if (ModList.get().isLoaded("modulargolems")) {
                GolemCompat.init();
            }
            AttackEventHandler.register((int)3943, (AttackListener)new GTAttackListener());
        });
    }

    @SubscribeEvent
    public static void onAttribute(EntityAttributeModificationEvent event) {
        for (EntityType e : event.getTypes()) {
            event.add(e, GTRegistries.MAX_MANA);
            event.add(e, GTRegistries.MANA_REGEN);
            GTRegistries.ELEMENT.reg().holders().forEach(x -> event.add(e, ((SpellElement)((Object)((Object)x.value()))).getAffinity()));
        }
        event.add(EntityType.PLAYER, GTRegistries.MAX_FOCUS);
        event.add(EntityType.PLAYER, GTRegistries.FOCUS_CD);
    }

    @SubscribeEvent
    public static void onDatapackRegistry(DataPackRegistryEvent.NewRegistry event) {
        CodecAdaptor spell = new CodecAdaptor(NatureSpell.class);
        CodecAdaptor graph = new CodecAdaptor(HexGraphData.class);
        event.dataPackRegistry(GTRegistries.SPELL, (Codec)spell, (Codec)spell);
        event.dataPackRegistry(GTRegistries.GRAPH, (Codec)graph, (Codec)graph);
    }

    @SubscribeEvent
    public static void registerCap(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, c) -> new BaseBagItemHandler(stack), new ItemLike[]{GTItems.WAND});
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)GTItems.ALTAR_BE.get(), BaseRitualBlockEntity::getItemHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)GTItems.MATRIX_BE.get(), BaseRitualBlockEntity::getItemHandler);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void gatherDataInit(GatherDataEvent event) {
        GlimmeringTales.initHandlers();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void gatherData(GatherDataEvent event) {
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, GTRecipeGen::onRecipeGen);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, GTTagGen::genItemTag);
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, GTTagGen::genBlockTag);
        REGISTRATE.addDataGenerator(ProviderType.ENTITY_TAGS, GTTagGen::genEntityTag);
        REGISTRATE.addDataGenerator(ProviderType.LANG, GTLang::addTranslations);
        REGISTRATE.addDataGenerator(ProviderType.DATA_MAP, GTDataMapGen::genMap);
        REGISTRATE.addDataGenerator(ProviderType.ADVANCEMENT, GTAdvGen::genAdvancements);
        REGISTRATE.addDataGenerator(ProviderType.LANG, GTSpells::addLang);
        REGISTRATE.addDataGenerator(ProviderType.DATA_MAP, GTSpells::genMap);
        REGISTRATE.addDataGenerator(GTTagGen.BIOME, GTWorldGen::genBiomeTags);
        REGISTRATE.addDataGenerator(GTTagGen.NATURE_SPELL, GTSpells::addTag);
        DataProviderInitializer init = REGISTRATE.getDataGenInitializer();
        DMG_GEN.generate();
        init.add(EngineRegistry.PROJECTILE, GTSpells::genProjectiles);
        init.add(EngineRegistry.SPELL, GTSpells::genSpells);
        init.add(GTRegistries.SPELL, GTSpells::genNature);
        init.add(GTRegistries.GRAPH, GTSpells::genGraph);
        GTWorldGen.genFeatures(init);
        init.addDependency(ProviderType.DATA_MAP, ProviderType.DYNAMIC);
        init.addDependency(GTTagGen.BIOME, ProviderType.DYNAMIC);
        init.addDependency(GTTagGen.NATURE_SPELL, ProviderType.DYNAMIC);
        DataGenerator gen = event.getGenerator();
        boolean run = event.includeServer();
        PackOutput out = gen.getPackOutput();
        ExistingFileHelper file = event.getExistingFileHelper();
        CompletableFuture pvd = event.getLookupProvider();
        gen.addProvider(run, (DataProvider)new GTSlotGen(out, file, pvd));
        gen.addProvider(run, (DataProvider)new GTHostilityGen(gen, pvd));
        gen.addProvider(run, (DataProvider)new GTParticleGen(out, file));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void gatherDataLate(GatherDataEvent event) {
        if (ModList.get().isLoaded("apotheosis")) {
            ApothCompat.data(event);
        }
    }

    public static ResourceLocation loc(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }
}

