/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.events;

import dev.xkmc.glimmeringtales.content.block.api.CropGrowListener;
import dev.xkmc.glimmeringtales.content.entity.hostile.MobCastingConfig;
import dev.xkmc.glimmeringtales.content.entity.hostile.SpellCastGoal;
import dev.xkmc.glimmeringtales.content.recipe.thunder.StrikeBlockRecipe;
import dev.xkmc.glimmeringtales.content.recipe.thunder.StrikeItemRecipe;
import dev.xkmc.glimmeringtales.init.data.GTTagGen;
import dev.xkmc.glimmeringtales.init.reg.GTRecipes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;

@EventBusSubscriber(modid="glimmeringtales", bus=EventBusSubscriber.Bus.GAME)
public class GTServerEventHandler {
    @SubscribeEvent
    public static void onCropGrow(CropGrowEvent.Post event) {
        Direction[] directionArray = event.getLevel();
        if (!(directionArray instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)directionArray;
        for (Direction e : Direction.values()) {
            BlockPos pos;
            BlockState state;
            Block block;
            if (e.getAxis() == Direction.Axis.Y || !((block = (state = level.getBlockState(pos = event.getPos().relative(e))).getBlock()) instanceof CropGrowListener)) continue;
            CropGrowListener block2 = (CropGrowListener)block;
            block2.onNeighborGrow(level, state, pos, event.getState());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityStruck(EntityStruckByLightningEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity ie = (ItemEntity)entity;
            Level level = ie.level();
            SingleRecipeInput cont = new SingleRecipeInput(ie.getItem());
            Optional ans = level.getRecipeManager().getRecipeFor((RecipeType)GTRecipes.RT_STRIKE_ITEM.get(), (RecipeInput)cont, level);
            ans.ifPresent(holder -> ie.setItem(((StrikeItemRecipe)holder.value()).assemble(cont, (HolderLookup.Provider)level.registryAccess())));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityAdded(EntityJoinLevelEvent event) {
        Mob mob;
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        Object object = event.getEntity();
        if (object instanceof LightningBolt) {
            LightningBolt ie = (LightningBolt)object;
            GTServerEventHandler.onThunder(level, ie);
        }
        if ((object = event.getEntity()) instanceof Mob && (mob = (Mob)object).getType().is(GTTagGen.CASTER)) {
            for (WrappedGoal e : mob.goalSelector.getAvailableGoals()) {
                if (!(e.getGoal() instanceof RangedAttackGoal) && !(e.getGoal() instanceof MeleeAttackGoal) && !(e.getGoal() instanceof RangedBowAttackGoal) && !(e.getGoal() instanceof RangedCrossbowAttackGoal)) continue;
                mob.goalSelector.addGoal(e.getPriority() - 1, (Goal)new SpellCastGoal(mob, MobCastingConfig.DEF));
                return;
            }
        }
    }

    private static void onThunder(Level level, LightningBolt ie) {
        BlockState hitState;
        BlockPos hitPos;
        BlockPos pos = BlockPos.containing((Position)ie.position().add(0.0, -1.0E-6, 0.0));
        BlockState state = level.getBlockState(pos);
        if (state.isAir()) {
            pos = pos.below();
            level.getBlockState(pos);
        }
        if (state.is(Blocks.LIGHTNING_ROD)) {
            hitPos = pos.relative(((Direction)state.getValue((Property)LightningRodBlock.FACING)).getOpposite());
            hitState = level.getBlockState(hitPos);
        } else {
            hitPos = pos;
            hitState = state;
        }
        StrikeBlockRecipe.Inv cont = new StrikeBlockRecipe.Inv(level, hitState, hitPos);
        Optional ans = level.getRecipeManager().getRecipeFor((RecipeType)GTRecipes.RT_STRIKE_BLOCK.get(), (RecipeInput)cont, level);
        if (ans.isEmpty()) {
            return;
        }
        ((StrikeBlockRecipe)((RecipeHolder)ans.get()).value()).assemble(cont, (HolderLookup.Provider)level.registryAccess());
    }
}

