/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.events;

import dev.xkmc.glimmeringtales.content.core.spell.NatureSpell;
import dev.xkmc.glimmeringtales.content.item.rune.BaseRuneItem;
import dev.xkmc.glimmeringtales.content.item.rune.SpellCoreItem;
import dev.xkmc.glimmeringtales.content.research.core.HexGraphData;
import dev.xkmc.glimmeringtales.content.research.core.OpenGraphPacket;
import dev.xkmc.glimmeringtales.content.research.core.PlayerResearch;
import dev.xkmc.glimmeringtales.content.research.core.ResearchState;
import dev.xkmc.glimmeringtales.content.research.core.SpellResearch;
import dev.xkmc.glimmeringtales.init.GlimmeringTales;
import dev.xkmc.l2core.util.ServerProxy;
import dev.xkmc.l2menustacker.click.ReadOnlyStackClickHandler;
import dev.xkmc.l2serial.network.SimplePacketBase;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GTClickHandler
extends ReadOnlyStackClickHandler {
    public GTClickHandler(ResourceLocation rl) {
        super(rl);
    }

    protected void handle(ServerPlayer player, ItemStack stack) {
        Item item;
        if (stack.getItem() instanceof SpellCoreItem) {
            GlimmeringTales.HANDLER.toClientPlayer((SimplePacketBase)new OpenGraphPacket(GlimmeringTales.loc("all")), player);
            return;
        }
        RegistryAccess reg = ServerProxy.getRegistryAccess();
        if (reg == null || !((item = stack.getItem()) instanceof BaseRuneItem)) {
            return;
        }
        BaseRuneItem rune = (BaseRuneItem)item;
        Holder<NatureSpell> spell = rune.getSpellInfo(reg).spell();
        if (spell == null) {
            return;
        }
        Holder<HexGraphData> graph = ((NatureSpell)spell.value()).graph();
        if (graph == null) {
            return;
        }
        ResourceLocation id = ((ResourceKey)graph.unwrapKey().orElseThrow()).location();
        SpellResearch prog = PlayerResearch.of((Player)player).get(id);
        if (prog == null || prog.getState() == ResearchState.LOCKED) {
            id = GlimmeringTales.loc("all");
        }
        GlimmeringTales.HANDLER.toClientPlayer((SimplePacketBase)new OpenGraphPacket(id), player);
    }

    public boolean isAllowed(ItemStack stack) {
        Item item;
        if (stack.getItem() instanceof SpellCoreItem) {
            return true;
        }
        RegistryAccess reg = ServerProxy.getRegistryAccess();
        if (reg != null && (item = stack.getItem()) instanceof BaseRuneItem) {
            BaseRuneItem rune = (BaseRuneItem)item;
            Holder<NatureSpell> spell = rune.getSpellInfo(reg).spell();
            return spell != null && ((NatureSpell)spell.value()).graph() != null;
        }
        return false;
    }
}

