/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.logic;

import dev.xkmc.glimmeringtales.content.research.logic.Frac;
import dev.xkmc.glimmeringtales.content.research.logic.HexDirection;
import dev.xkmc.glimmeringtales.content.research.logic.HexHandler;
import dev.xkmc.glimmeringtales.content.research.logic.SubHex;
import javax.annotation.Nullable;

public class HexCell {
    private final HexHandler hexHandler;
    public int row;
    public int cell;

    public HexCell(HexHandler hexHandler, int row, int cell) {
        this.hexHandler = hexHandler;
        this.row = row;
        this.cell = cell;
    }

    public boolean canWalk(HexDirection dir) {
        int dr = dir.getRowOffset();
        int dc = dir.getCellOffset(this.hexHandler.radius, this.row, this.cell);
        return this.row + dr >= 0 && this.row + dr < this.hexHandler.getRowCount() && this.cell + dc >= 0 && this.cell + dc < this.hexHandler.getCellCount(this.row + dr);
    }

    public boolean exists() {
        return this.hexHandler.cells[this.row][this.cell] > 0;
    }

    public SubHex getSubHex() {
        return this.hexHandler.subhex[this.hexHandler.getInd(this.row, this.cell)];
    }

    public double getX() {
        return this.hexHandler.getX(this.row, this.cell);
    }

    public double getY() {
        return this.hexHandler.getY(this.row, this.cell);
    }

    public boolean isConnected(HexDirection dir) {
        return (this.hexHandler.cells[this.row][this.cell] & dir.mask()) != 0;
    }

    public boolean isCorner() {
        return this.row % this.hexHandler.radius == 0 && (this.cell == 0 || this.cell == this.hexHandler.cells[this.row].length - 1);
    }

    public boolean isCorner(HexDirection dir) {
        int nr = this.row + dir.getRowOffset();
        int nc = this.cell + dir.getCellOffset(this.hexHandler.radius, this.row, this.cell);
        return nr % this.hexHandler.radius == 0 && (nc == 0 || nc == this.hexHandler.cells[nr].length - 1);
    }

    public Frac[][] matrix() {
        if (this.hexHandler.subhex[this.hexHandler.getInd(this.row, this.cell)] != null) {
            return this.hexHandler.subhex[this.hexHandler.getInd(this.row, this.cell)].getMatrix();
        }
        Frac[][] ans = new Frac[6][];
        for (int i = 0; i < 6; ++i) {
            HexDirection dir = HexDirection.values()[i];
            if (!this.isConnected(dir)) continue;
            ans[i] = new Frac[6];
            HexDirection opo = dir.next(3);
            if (this.isConnected(opo)) {
                ans[i][opo.ind] = new Frac(1L, 1L);
                continue;
            }
            HexDirection ccw = dir.next(2);
            HexDirection cw = dir.next(4);
            boolean bc0 = this.isConnected(ccw);
            boolean bc1 = this.isConnected(cw);
            if (bc0 || bc1) {
                if (bc0 && bc1) {
                    Frac frac = new Frac(1L, 2L);
                    ans[i][cw.ind] = frac;
                    ans[i][ccw.ind] = frac;
                    continue;
                }
                if (bc0) {
                    ans[i][ccw.ind] = new Frac(1L, 1L);
                    continue;
                }
                ans[i][cw.ind] = new Frac(1L, 1L);
                continue;
            }
            HexDirection bccw = dir.next(1);
            HexDirection bcw = dir.next(5);
            bc0 = this.isConnected(bccw);
            bc1 = this.isConnected(bcw);
            if (bc0 || bc1) {
                if (bc0 && bc1) {
                    Frac frac = new Frac(1L, 2L);
                    ans[i][bcw.ind] = frac;
                    ans[i][bccw.ind] = frac;
                    continue;
                }
                if (bc0) {
                    ans[i][bccw.ind] = new Frac(1L, 1L);
                    continue;
                }
                ans[i][bcw.ind] = new Frac(1L, 1L);
                continue;
            }
            ans[i][i] = new Frac(1L, 1L);
        }
        return ans;
    }

    public void set(HexHandler.SubHexCore sub, int i, boolean b) {
        this.hexHandler.subhex[this.hexHandler.getInd((int)this.row, (int)this.cell)] = new SubHex(sub, i, b);
    }

    public void toggle(HexDirection dir) {
        if (!this.canWalk(dir)) {
            return;
        }
        byte val = this.hexHandler.cells[this.row][this.cell];
        if (this.isCorner() && val != 0 && val != dir.mask()) {
            this.hexHandler.cells[this.row][this.cell] = 0;
            for (HexDirection d : HexDirection.values()) {
                if ((val & d.mask()) == 0) continue;
                int dr = d.getRowOffset();
                int dc = d.getCellOffset(this.hexHandler.radius, this.row, this.cell);
                byte[] byArray = this.hexHandler.cells[this.row + dr];
                int n = this.cell + dc;
                byArray[n] = (byte)(byArray[n] ^ d.next(3).mask());
            }
        }
        int dr = this.row + dir.getRowOffset();
        int dc = this.cell + dir.getCellOffset(this.hexHandler.radius, this.row, this.cell);
        byte dval = this.hexHandler.cells[dr][dc];
        if (this.isCorner(dir) && dval != 0 && dval != dir.next(3).mask()) {
            this.hexHandler.cells[dr][dc] = 0;
            for (HexDirection d : HexDirection.values()) {
                if ((dval & d.mask()) == 0) continue;
                int xr = d.getRowOffset();
                int xc = d.getCellOffset(this.hexHandler.radius, dr, dc);
                byte[] byArray = this.hexHandler.cells[dr + xr];
                int n = dc + xc;
                byArray[n] = (byte)(byArray[n] ^ d.next(3).mask());
            }
        }
        byte[] byArray = this.hexHandler.cells[this.row];
        int n = this.cell;
        byArray[n] = (byte)(byArray[n] ^ dir.mask());
        byte[] byArray2 = this.hexHandler.cells[dr];
        int n2 = dc;
        byArray2[n2] = (byte)(byArray2[n2] ^ dir.next(3).mask());
    }

    public void walk(HexDirection dir) {
        if (!this.canWalk(dir)) {
            return;
        }
        int dr = dir.getRowOffset();
        int dc = dir.getCellOffset(this.hexHandler.radius, this.row, this.cell);
        this.row += dr;
        this.cell += dc;
    }

    public void walk(HexDirection dir, int n) {
        for (int i = 0; i < n; ++i) {
            this.walk(dir);
        }
    }

    boolean isInvalid() {
        for (HexDirection dir : HexDirection.values()) {
            if (this.canWalk(dir)) {
                boolean b1;
                int dr = dir.getRowOffset();
                int dc = dir.getCellOffset(this.hexHandler.radius, this.row, this.cell);
                boolean b0 = (this.hexHandler.cells[this.row][this.cell] & dir.mask()) != 0;
                boolean bl = b1 = (this.hexHandler.cells[this.row + dr][this.cell + dc] & dir.next(3).mask()) != 0;
                if (b0 == b1) continue;
                return true;
            }
            if ((this.hexHandler.cells[this.row][this.cell] & dir.mask()) == 0) continue;
            return true;
        }
        SubHex sub = this.hexHandler.subhex[this.hexHandler.getInd(this.row, this.cell)];
        return sub != null && sub.isInvalid(this) != 0;
    }

    @Nullable
    public HexDirection getCorner() {
        if (this.row == 0) {
            if (this.cell == 0) {
                return HexDirection.UPPER_LEFT;
            }
            if (this.cell == this.hexHandler.cells[this.row].length - 1) {
                return HexDirection.UPPER_RIGHT;
            }
            return null;
        }
        if (this.row == this.hexHandler.radius) {
            if (this.cell == 0) {
                return HexDirection.LEFT;
            }
            if (this.cell == this.hexHandler.cells[this.row].length - 1) {
                return HexDirection.RIGHT;
            }
            return null;
        }
        if (this.row == this.hexHandler.radius * 2) {
            if (this.cell == 0) {
                return HexDirection.LOWER_LEFT;
            }
            if (this.cell == this.hexHandler.cells[this.row].length - 1) {
                return HexDirection.LOWER_RIGHT;
            }
            return null;
        }
        return null;
    }

    public void toCorner(HexDirection selected) {
        this.row = this.hexHandler.radius;
        this.cell = this.hexHandler.radius;
        this.walk(selected, this.hexHandler.radius);
    }
}

