/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.logic;

public class Frac
implements Comparable<Frac> {
    public long num;
    public long den;
    public double val;
    public boolean isFrac = true;

    public Frac(long num, long den) {
        this.num = num;
        this.den = den;
        this.validate();
    }

    private Frac(double val) {
        this.val = val;
        this.isFrac = false;
    }

    public static Frac mult(Frac f0, Frac f1) {
        if (!f0.isFrac || !f1.isFrac) {
            return new Frac(f0.getVal() * f1.getVal());
        }
        if (f0.den == 0L || f1.den == 0L) {
            return new Frac(1L, 0L);
        }
        try {
            long gcd0 = Frac.gcd(f0.num, f1.den);
            long gcd1 = Frac.gcd(f1.num, f0.den);
            long num = Math.multiplyExact(f0.num / gcd0, f1.num / gcd1);
            long den = Math.multiplyExact(f0.den / gcd1, f1.den / gcd0);
            return new Frac(num, den);
        }
        catch (Exception e) {
            return new Frac(f0.getVal() * f1.getVal());
        }
    }

    private static long gcd(long a, long b) {
        long max = Math.max(a, b);
        long min = Math.min(a, b);
        return min == 0L ? max : Frac.gcd(min, max % min);
    }

    public void add(Frac o) {
        if (!this.isFrac || !o.isFrac) {
            this.isFrac = false;
            this.val = this.getVal() + o.getVal();
            this.den = 0L;
            this.num = 0L;
            return;
        }
        if (this.den == 0L) {
            return;
        }
        if (o.den == 0L) {
            this.den = 0L;
            this.num = 1L;
            return;
        }
        double val = this.getVal();
        try {
            long gcd = Frac.gcd(this.den, o.den);
            long v0 = Math.multiplyExact(this.num, o.den / gcd);
            long v1 = Math.multiplyExact(o.num, this.den / gcd);
            this.num = Math.addExact(v0, v1);
            this.den = Math.multiplyExact(this.den, o.den / gcd);
        }
        catch (Exception e) {
            this.isFrac = false;
            this.den = 0L;
            this.num = 0L;
            this.val = val + o.getVal();
        }
        this.validate();
    }

    @Override
    public int compareTo(Frac o) {
        if (this.equals(o)) {
            return 0;
        }
        return Double.compare(this.getVal(), o.getVal());
    }

    public boolean equals(Object o) {
        if (o instanceof Frac) {
            Frac f = (Frac)o;
            if (!this.isFrac || !f.isFrac) {
                return false;
            }
            return f.num == this.num && f.den == this.den;
        }
        return false;
    }

    public double getVal() {
        if (!this.isFrac) {
            return this.val;
        }
        if (this.den == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        return 1.0 * (double)this.num / (double)this.den;
    }

    public void times(Frac base) {
        if (!this.isFrac || !base.isFrac) {
            this.isFrac = false;
            this.val = this.getVal() * base.getVal();
            this.den = 0L;
            this.num = 0L;
            return;
        }
        if (this.den == 0L) {
            return;
        }
        double val = this.getVal();
        try {
            long gcd0 = Frac.gcd(this.num, base.den);
            long gcd1 = Frac.gcd(base.num, this.den);
            this.num = Math.multiplyExact(this.num / gcd0, base.num / gcd1);
            this.den = Math.multiplyExact(this.den / gcd1, base.den / gcd0);
            this.validate();
        }
        catch (Exception e) {
            this.isFrac = false;
            this.den = 0L;
            this.num = 0L;
            this.val = val * base.getVal();
        }
    }

    public String toString() {
        if (!this.isFrac || this.num > 100L || this.den > 100L) {
            return "" + (double)Math.round(this.getVal() * 100.0) / 100.0;
        }
        return this.num + "/" + this.den;
    }

    private void validate() {
        if (!this.isFrac) {
            return;
        }
        if (this.den == 0L) {
            this.num = 1L;
            return;
        }
        long gcd = Frac.gcd(this.num, this.den);
        this.num /= gcd;
        this.den /= gcd;
    }

    public Frac revert() {
        if (this.isFrac) {
            return new Frac(this.den, this.den - this.num);
        }
        return new Frac(1.0 / (1.0 - this.val));
    }
}

