/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.logic;

import dev.xkmc.glimmeringtales.content.research.logic.AbstractHex;
import dev.xkmc.glimmeringtales.content.research.logic.HexHandler;
import dev.xkmc.glimmeringtales.content.research.logic.LocateResult;
import javax.annotation.Nullable;

public class CellResult
extends LocateResult {
    private final int row;
    private final int cell;
    private final AbstractHex hex;

    CellResult(int row, int cell, AbstractHex hex) {
        this.row = row;
        this.cell = cell;
        this.hex = hex;
    }

    @Nullable
    public static CellResult get(int row, int cell, HexHandler hex) {
        if (row < 0 || row >= hex.getRowCount()) {
            return null;
        }
        if (cell < 0 || cell >= hex.getCellCount(row)) {
            return null;
        }
        return new CellResult(row, cell, hex);
    }

    @Override
    public LocateResult.ResultType getType() {
        return LocateResult.ResultType.CELL;
    }

    @Override
    public double getX() {
        return this.hex.getX(this.row, this.cell);
    }

    @Override
    public double getY() {
        return this.hex.getY(this.row, this.cell);
    }

    public int getRow() {
        return this.row;
    }

    public int getCell() {
        return this.cell;
    }
}

