/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.core;

import dev.xkmc.glimmeringtales.content.core.spell.ResearchBonus;
import dev.xkmc.glimmeringtales.content.core.spell.SpellElement;
import dev.xkmc.glimmeringtales.content.research.core.HexGraph;
import dev.xkmc.glimmeringtales.content.research.core.HexGraphData;
import dev.xkmc.glimmeringtales.content.research.core.HexOrder;
import dev.xkmc.glimmeringtales.content.research.core.PlayerResearch;
import dev.xkmc.glimmeringtales.content.research.core.ResearchData;
import dev.xkmc.glimmeringtales.content.research.core.ResearchDependency;
import dev.xkmc.glimmeringtales.content.research.core.ResearchState;
import dev.xkmc.glimmeringtales.content.research.logic.HexHandler;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class SpellResearch {
    public static final int UNLOCKED = -1;
    private final PlayerResearch player;
    private final ResourceLocation id;
    private final ResearchData data;
    private final HexGraph graph;
    private final HexGraphData def;

    public SpellResearch(PlayerResearch player, HexGraphData def, ResourceLocation id, ResearchData data, HexGraph graph) {
        this.player = player;
        this.id = id;
        this.data = data;
        this.graph = graph;
        this.def = def;
    }

    public final int getCost() {
        return this.data.cost();
    }

    public void updateBestSolution(HexHandler hex, HexOrder data, int cost) {
        this.data.update(hex, data, cost);
    }

    public HexHandler getSolution() {
        return this.data.hex();
    }

    public final boolean usable() {
        return this.data.cost() > -1;
    }

    public ResearchState getState() {
        SpellResearch parent;
        if (this.usable()) {
            return ResearchState.COMPLETED;
        }
        ResearchDependency par = this.def.parent();
        if (!(par == null || (parent = this.player.get(par.getId())) != null && parent.usable())) {
            return ResearchState.LOCKED;
        }
        return ResearchState.UNLOCKED;
    }

    public boolean bested() {
        if (!this.usable()) {
            return false;
        }
        for (ResearchBonus e : this.def.bonuses()) {
            if (this.data.cost() <= e.cost()) continue;
            return false;
        }
        return true;
    }

    public boolean visible() {
        return true;
    }

    public HexOrder getMiscData() {
        return this.data.order().copy();
    }

    public boolean matchList(List<SpellElement> elem) {
        return elem.equals(this.data.order().list());
    }

    public HexGraph getGraph() {
        return this.graph;
    }

    public void save() {
        this.player.save(this.id, this.data);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void getFullDesc(List<Component> list, List<ResearchBonus> bonuses) {
        list.add((Component)GTLang.HEX_STATUS.get(this.getState().getDesc().withStyle(this.getState() == ResearchState.UNLOCKED ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.GRAY)).withStyle(ChatFormatting.GRAY));
        if (!this.usable()) {
            return;
        }
        MutableComponent cost = Component.literal((String)("" + this.getCost())).withStyle(ChatFormatting.AQUA);
        list.add((Component)GTLang.HEX_COST.get(cost).withStyle(ChatFormatting.GRAY));
        list.add((Component)GTLang.HEX_BONUS.get(new Object[0]).withStyle(ChatFormatting.GRAY));
        for (ResearchBonus e : bonuses) {
            ChatFormatting format = this.getCost() <= e.cost() ? ChatFormatting.YELLOW : ChatFormatting.DARK_GRAY;
            list.add((Component)e.desc().withStyle(format));
            if (this.getCost() <= e.cost()) continue;
            break;
        }
    }
}

