/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.core;

import dev.xkmc.glimmeringtales.content.capability.PlayerResearchCapability;
import dev.xkmc.glimmeringtales.content.research.core.GraphToServerPacket;
import dev.xkmc.glimmeringtales.content.research.core.HexGraph;
import dev.xkmc.glimmeringtales.content.research.core.HexGraphData;
import dev.xkmc.glimmeringtales.content.research.core.ResearchData;
import dev.xkmc.glimmeringtales.content.research.core.SpellResearch;
import dev.xkmc.glimmeringtales.init.GlimmeringTales;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2serial.network.SimplePacketBase;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class PlayerResearch {
    private final Player player;
    private final PlayerResearchCapability data;
    private final Map<ResourceLocation, SpellResearch> cache = new LinkedHashMap<ResourceLocation, SpellResearch>();
    private Set<ResourceLocation> validSpells;

    public static PlayerResearch of(Player player) {
        return new PlayerResearch(player, (PlayerResearchCapability)((PlayerCapabilityHolder)GTRegistries.RESEARCH.type()).getOrCreate((IAttachmentHolder)player));
    }

    public PlayerResearch(Player player, PlayerResearchCapability data) {
        this.player = player;
        this.data = data;
    }

    public Player player() {
        return this.player;
    }

    @Nullable
    public SpellResearch get(ResourceLocation id) {
        ResearchData dat = this.data.get(id);
        return this.get(id, dat);
    }

    @Nullable
    public SpellResearch get(ResourceLocation id, @Nullable ResearchData dat) {
        Registry reg = this.player.level().registryAccess().registryOrThrow(GTRegistries.GRAPH);
        if (this.validSpells == null) {
            this.validSpells = reg.holders().map(e -> e.key().location()).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        if (!this.validSpells.contains(id)) {
            return null;
        }
        if (this.cache.containsKey(id)) {
            return this.cache.get(id);
        }
        HexGraphData graph = (HexGraphData)reg.get(id);
        if (graph == null) {
            return null;
        }
        if (dat == null) {
            dat = ResearchData.create(graph.map().size());
        }
        HexGraph map = HexGraph.create(id, graph.map(), graph.flows());
        SpellResearch ans = new SpellResearch(this, graph, id, dat, map);
        this.cache.put(id, ans);
        return ans;
    }

    protected void save(ResourceLocation id, ResearchData dat) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            SpellResearch research = this.get(id);
            if (research != null) {
                this.data.put(id, dat);
            }
            this.data.sync(sp);
        } else {
            this.data.put(id, dat);
            GlimmeringTales.HANDLER.toServer((SimplePacketBase)new GraphToServerPacket(id, dat));
        }
    }
}

