/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.core;

import dev.xkmc.glimmeringtales.content.core.spell.SpellElement;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;

public record HexGraph(SpellElement[] elements, boolean[][] graph) {
    @Nullable
    public SpellElement getElem(int index) {
        return index >= this.elements.length ? null : this.elements[index];
    }

    public boolean connected(int src, int dst) {
        return this.graph[src][dst];
    }

    public static HexGraph create(ResourceLocation id, Map<String, SpellElement> elements, List<String> flows) {
        int n = elements.size();
        SpellElement[] elems = new SpellElement[n];
        char[] chars = new char[n];
        int i = 0;
        for (Map.Entry<String, SpellElement> ent : elements.entrySet()) {
            elems[i] = ent.getValue();
            if (ent.getKey().length() != 1) {
                LogManager.getLogger().error("key length not 1 in {}", (Object)id);
            }
            chars[i] = ent.getKey().charAt(0);
            ++i;
        }
        boolean[][] bools = new boolean[6][6];
        for (String flow : flows) {
            String[] strs;
            if (flow.contains("<->")) {
                strs = flow.split("<->");
                if (strs.length == 2 && HexGraph.flowRegex(chars, strs[0], strs[1], bools, true)) continue;
                LogManager.getLogger().error("illegal side expression{} in {}", (Object)flow, (Object)id);
                continue;
            }
            if (flow.contains("->")) {
                strs = flow.split("->");
                if (strs.length == 2 && HexGraph.flowRegex(chars, strs[0], strs[1], bools, false)) continue;
                LogManager.getLogger().error("illegal side expression {} in {}", (Object)flow, (Object)id);
                continue;
            }
            if (flow.endsWith("|")) {
                if (HexGraph.flowRound(chars, flow.substring(0, flow.length() - 1), bools)) continue;
                LogManager.getLogger().error("illegal round expression {} in {}", (Object)flow, (Object)id);
                continue;
            }
            LogManager.getLogger().error("illegal connector {} in {}", (Object)flow, (Object)id);
        }
        return new HexGraph(elems, bools);
    }

    private static boolean flowRegex(char[] chars, String s0, String s1, boolean[][] bools, boolean bidirect) {
        int c;
        int i;
        int[] i0 = new int[s0.length()];
        int[] i1 = new int[s1.length()];
        for (i = 0; i < s0.length(); ++i) {
            i0[i] = -1;
            for (c = 0; c < chars.length; ++c) {
                if (chars[c] != s0.charAt(i)) continue;
                i0[i] = c;
                break;
            }
            if (i0[i] != -1) continue;
            return false;
        }
        for (i = 0; i < s1.length(); ++i) {
            i1[i] = -1;
            for (c = 0; c < chars.length; ++c) {
                if (chars[c] != s1.charAt(i)) continue;
                i1[i] = c;
                break;
            }
            if (i1[i] != -1) continue;
            return false;
        }
        for (int k : i0) {
            for (int i2 : i1) {
                if (k == i2) {
                    return false;
                }
                if (bools[k][i2]) {
                    return false;
                }
                bools[k][i2] = true;
                if (!bidirect) continue;
                if (bools[i2][k]) {
                    return false;
                }
                bools[i2][k] = true;
            }
        }
        return true;
    }

    private static boolean flowRound(char[] chars, String str, boolean[][] bools) {
        int[] i0 = new int[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            i0[i] = -1;
            for (int c = 0; c < chars.length; ++c) {
                if (chars[c] != str.charAt(i)) continue;
                i0[i] = c;
                break;
            }
            if (i0[i] != -1) continue;
            return false;
        }
        for (int i : i0) {
            for (int j : i0) {
                if (i == j) continue;
                bools[i][j] = true;
            }
        }
        return true;
    }
}

