/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.client.tree;

import dev.xkmc.glimmeringtales.content.research.client.base.AbstractHexGui;
import dev.xkmc.glimmeringtales.content.research.client.base.AbstractScalableGui;
import dev.xkmc.glimmeringtales.content.research.client.graph.HexRenderUtil;
import dev.xkmc.glimmeringtales.content.research.client.graph.MagicHexScreen;
import dev.xkmc.glimmeringtales.content.research.client.tree.ResearchNode;
import dev.xkmc.glimmeringtales.content.research.client.tree.ResearchTree;
import dev.xkmc.glimmeringtales.content.research.client.tree.ResearchTreeScreen;
import dev.xkmc.glimmeringtales.content.research.core.HexGraphData;
import dev.xkmc.glimmeringtales.content.research.core.ResearchState;
import dev.xkmc.glimmeringtales.content.research.logic.HexHalfResult;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class TreeNodeGui
extends AbstractScalableGui {
    private static final double MARGIN = 0.9;
    private static final double RADIUS = 2.0 / Math.sqrt(3.0);
    private static final int COL_BG = -8421505;
    private static final int COL_ENABLED = -1;
    private static final int COL_DISABLED = -12632257;
    private static final int COL_HOVER = -256;
    private static final int COL_LOCKED = -10526881;
    private static final int COL_UNLOCKED = -32769;
    private static final int COL_COMPLETE = -8388609;
    private static final int COL_BEST = -129;
    private final ResearchTreeScreen screen;
    ResearchTree tree;
    private int tick;

    public TreeNodeGui(ResearchTreeScreen screen) {
        this.screen = screen;
        this.tree = screen.tree;
    }

    @Override
    public void initScale() {
        this.magn = (float)Math.min(this.box.w, this.box.h) / 16.0f;
    }

    public void render(GuiGraphics g, double mx, double my, float partial) {
        double x0 = (double)this.box.x + (double)this.box.w / 2.0;
        double y0 = (double)this.box.y + (double)this.box.h / 2.0;
        g.pose().pushPose();
        g.pose().translate(x0 + this.scrollX, y0 + this.scrollY, 0.0);
        ResearchNode hover = this.tree.getElementOnHex(this.getMX(mx), this.getMY(my));
        this.renderBG(g, hover);
        double ratio = 0.25;
        double width = RADIUS * ratio * (double)this.magn;
        double length = 2.0 * (1.0 - ratio) * (double)this.magn;
        this.renderPath(g, width, length);
        this.renderIcons(g);
        g.pose().popPose();
    }

    public void renderHover(GuiGraphics g, double mx, double my) {
        ResearchNode hover = this.tree.getElementOnHex(this.getMX(mx), this.getMY(my));
        this.renderTooltip(g, (int)mx, (int)my, hover);
    }

    public boolean mouseClicked(double mx, double my, int button) {
        ResearchNode hover;
        if (button == 0 && (hover = this.tree.getElementOnHex(this.getMX(mx), this.getMY(my))) != null && hover.data.getState() != ResearchState.LOCKED) {
            Minecraft.getInstance().setScreen((Screen)new MagicHexScreen(this.screen, hover.data));
        }
        return false;
    }

    public void tick() {
        ++this.tick;
    }

    private void renderBG(GuiGraphics g, @Nullable ResearchNode hover) {
        HexRenderUtil.hex_start(g);
        for (Map.Entry<HexHalfResult, ResearchNode> ent : this.tree.locatedNodes.entrySet()) {
            int col;
            ResearchNode node = ent.getValue();
            double x = node.getX() * (double)this.magn;
            double y = node.getY() * (double)this.magn;
            double r = 0.9 * RADIUS * (double)this.magn;
            switch (node.data.getState()) {
                default: {
                    throw new MatchException(null, null);
                }
                case LOCKED: {
                    int n = -10526881;
                    break;
                }
                case UNLOCKED: {
                    int n = -32769;
                    break;
                }
                case COMPLETED: {
                    int n = col = -8388609;
                }
            }
            if (node.data.bested()) {
                col = -129;
            }
            HexRenderUtil.hex(x, y, r, col);
            HexRenderUtil.hex(x, y, r * 0.8, -8421505);
        }
        if (hover != null) {
            HexRenderUtil.hex(hover.getX() * (double)this.magn, hover.getY() * (double)this.magn, RADIUS * (double)this.magn / 2.0, -256);
        }
        HexRenderUtil.common_end();
    }

    private void renderPath(GuiGraphics g, double width, double length) {
        HexRenderUtil.path_start(g, width, length, 2.0 * (double)this.magn, 0.0f);
        for (Map.Entry<HexHalfResult, ResearchNode> ent : this.tree.locatedNodes.entrySet()) {
            int col;
            ResearchNode node = ent.getValue();
            double x = node.getX() * (double)this.magn;
            double y = node.getY() * (double)this.magn;
            int n = col = node.unlocked() ? -1 : -12632257;
            if (node.main != null) {
                HexRenderUtil.path(x, y, 0, col);
            }
            if (node.branch != null) {
                HexRenderUtil.path(x, y, 1, col);
            }
            if (node.next == null) continue;
            x = node.next.getX() * (double)this.magn;
            y = node.next.getY() * (double)this.magn;
            HexRenderUtil.path(x, y, 2, col);
        }
        HexRenderUtil.common_end();
    }

    private void renderIcons(GuiGraphics g) {
        for (Map.Entry<HexHalfResult, ResearchNode> ent : this.tree.locatedNodes.entrySet()) {
            ResearchNode node = ent.getValue();
            double x = node.getX() * (double)this.magn;
            double y = node.getY() * (double)this.magn;
            AbstractHexGui.drawItem(g, node.getIcon(), x, y, this.magn / 10.0f);
        }
    }

    private void renderTooltip(GuiGraphics g, int mx, int my, @Nullable ResearchNode hover) {
        if (hover == null) {
            return;
        }
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(((HexGraphData)hover.hex.value()).icon().getDescription());
        hover.data.getFullDesc(list, ((HexGraphData)hover.hex.value()).bonuses());
        AbstractHexGui.drawHover(g, list, mx, my);
    }
}

