/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.client.tree;

import dev.xkmc.glimmeringtales.content.research.client.base.WindowBox;
import dev.xkmc.glimmeringtales.content.research.client.tree.ResearchNode;
import dev.xkmc.glimmeringtales.content.research.client.tree.ResearchTree;
import dev.xkmc.glimmeringtales.content.research.client.tree.TreeNodeGui;
import dev.xkmc.glimmeringtales.content.research.core.SpellResearch;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ResearchTreeScreen
extends Screen {
    private static final Component TITLE = Component.empty();
    public final Screen parent;
    public final ResearchTree tree;
    public final TreeNodeGui graph;
    private double accurate_mouse_x;
    private double accurate_mouse_y;
    private boolean isScrolling = false;

    public ResearchTreeScreen(ResearchTree tree) {
        super(TITLE);
        this.parent = Minecraft.getInstance().screen;
        this.tree = tree;
        this.graph = new TreeNodeGui(this);
    }

    public void init() {
        int sw = this.width;
        int sh = this.height;
        int h = (int)(Math.min((double)sw / 300.0, (double)sh / 200.0) * 150.0);
        int w = (int)((double)h * 1.5);
        int x0 = (sw - w) / 2;
        int y0 = (sh - h) / 2;
        this.graph.box.setSize(this, x0, y0, w, h, 8);
        this.graph.initScale();
    }

    public void focusOn(SpellResearch product) {
        ResearchNode node = this.tree.allNodes.get(product.getId());
        if (node != null) {
            this.graph.scrollTo(node.getX(), node.getY());
        }
    }

    public void render(GuiGraphics g, int mx, int my, float partial) {
        int col_bg = -4144960;
        int col_m0 = -8355712;
        int col_m1 = -1;
        super.renderBackground(g, mx, my, partial);
        super.render(g, 0, 0, partial);
        if (Math.abs(this.accurate_mouse_x - (double)mx) > 1.0) {
            this.accurate_mouse_x = mx;
        }
        if (Math.abs(this.accurate_mouse_y - (double)my) > 1.0) {
            this.accurate_mouse_y = my;
        }
        this.graph.box.render(g, 0, col_bg, WindowBox.RenderType.FILL);
        this.graph.box.startClip(g);
        this.graph.render(g, this.accurate_mouse_x, this.accurate_mouse_y, partial);
        this.graph.box.endClip(g);
        this.graph.box.render(g, 8, col_m1, WindowBox.RenderType.MARGIN);
        this.graph.box.render(g, 2, col_m0, WindowBox.RenderType.MARGIN);
        this.graph.renderHover(g, mx, my);
    }

    public void tick() {
        super.tick();
        this.graph.tick();
    }

    public void mouseMoved(double mx, double my) {
        if (this.isScrolling) {
            return;
        }
        this.accurate_mouse_x = mx;
        this.accurate_mouse_y = my;
    }

    public boolean mouseDragged(double x0, double y0, int button, double dx, double dy) {
        if (button != 0) {
            this.isScrolling = false;
            return false;
        }
        if (this.graph.box.isMouseIn(x0, y0, 0)) {
            this.isScrolling = true;
            this.graph.scroll(dx, dy);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double x0, double y0, int button) {
        return super.mouseReleased(x0, y0, button);
    }

    public boolean mouseClicked(double mx, double my, int button) {
        if (this.graph.box.isMouseIn(mx, my, 0) && this.graph.mouseClicked(mx, my, button)) {
            return true;
        }
        return super.mouseClicked(mx, my, button);
    }

    public boolean mouseScrolled(double mx, double my, double ignored, double amount) {
        if (this.graph.box.isMouseIn(mx, my, 0) && this.graph.mouseScrolled(mx, my, amount)) {
            return true;
        }
        return super.mouseScrolled(mx, my, amount, ignored);
    }

    public boolean charTyped(char ch, int type) {
        return super.charTyped(ch, type);
    }

    public boolean keyPressed(int key, int scan, int modifier) {
        return super.keyPressed(key, scan, modifier);
    }

    public void onClose() {
        if (this.minecraft != null && this.minecraft.screen == this && this.parent != null) {
            this.minecraft.setScreen(this.parent);
        }
    }
}

