/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.client.tree;

import dev.xkmc.glimmeringtales.content.research.client.tree.ResearchNode;
import dev.xkmc.glimmeringtales.content.research.core.HexGraphData;
import dev.xkmc.glimmeringtales.content.research.core.PlayerResearch;
import dev.xkmc.glimmeringtales.content.research.core.ResearchDependency;
import dev.xkmc.glimmeringtales.content.research.logic.AbstractHex;
import dev.xkmc.glimmeringtales.content.research.logic.HexDirection;
import dev.xkmc.glimmeringtales.content.research.logic.HexHalfResult;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ResearchTree
extends AbstractHex {
    private final Player player;
    final PlayerResearch data;
    ResearchNode root;
    final Map<ResourceLocation, ResearchNode> allNodes = new LinkedHashMap<ResourceLocation, ResearchNode>();
    final Map<HexHalfResult, ResearchNode> locatedNodes = new LinkedHashMap<HexHalfResult, ResearchNode>();

    public ResearchTree(Player player, PlayerResearch data) {
        this.player = player;
        this.data = data;
        this.init();
    }

    public void init() {
        this.allNodes.clear();
        this.locatedNodes.clear();
        this.root = null;
        Registry reg = this.player.level().registryAccess().registryOrThrow(GTRegistries.GRAPH);
        for (Holder.Reference reference : reg.holders().toList()) {
            ResearchNode node = new ResearchNode(this, (Holder<HexGraphData>)reference);
            this.allNodes.put(node.id, node);
            if (((HexGraphData)reference.value()).parent() != null || this.root != null) continue;
            this.root = node;
        }
        for (ResearchNode researchNode : this.allNodes.values()) {
            ResourceLocation parId;
            ResearchNode parNode;
            ResearchDependency par = ((HexGraphData)researchNode.hex.value()).parent();
            if (par == null || (parNode = this.allNodes.get(parId = ((ResourceKey)par.parent().unwrapKey().orElseThrow()).location())) == null) continue;
            parNode.add(par.type(), researchNode);
        }
        if (this.root == null) {
            return;
        }
        this.root.init(0, 0);
    }

    @Nullable
    public ResearchNode getElementOnHex(double x, double y) {
        int row = (int)Math.floor(y / HEIGHT + 0.5);
        double rel_y = y - (double)row * HEIGHT;
        int cell = (int)Math.floor(x / 2.0 + 0.5 - (double)row * 0.5);
        double rel_x = x - ((double)Math.abs(row) * 0.5 + (double)cell) * 2.0;
        double xoff = 0.5;
        double yoff = HEIGHT / 6.0;
        HexDirection dire = rel_y > 0.0 ? (rel_x > 0.0 ? HexDirection.LOWER_RIGHT : HexDirection.LOWER_LEFT) : (rel_x > 0.0 ? HexDirection.UPPER_RIGHT : HexDirection.UPPER_LEFT);
        rel_x = Math.abs(rel_x) - xoff;
        rel_y = Math.abs(rel_y) - yoff * 2.0;
        if (rel_x > 0.0 && rel_y > 0.0 && rel_x / xoff + rel_y / yoff > 1.0) {
            cell += dire.getCellOffset(0, row, cell);
            row += dire.getRowOffset();
        }
        HexHalfResult pos = new HexHalfResult(row, cell);
        return this.locatedNodes.get(pos);
    }

    @Override
    public double getX(int row, int cell) {
        return (double)cell * 2.0 + (double)row * 2.0 / 2.0;
    }

    @Override
    public double getY(int row, int cell) {
        return (double)row * HEIGHT;
    }
}

