/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.client.tree;

import dev.xkmc.glimmeringtales.content.research.client.tree.ResearchTree;
import dev.xkmc.glimmeringtales.content.research.core.HexGraphData;
import dev.xkmc.glimmeringtales.content.research.core.ResearchDependency;
import dev.xkmc.glimmeringtales.content.research.core.SpellResearch;
import dev.xkmc.glimmeringtales.content.research.logic.HexHalfResult;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ResearchNode {
    private final ResearchTree tree;
    final Holder<HexGraphData> hex;
    final ResourceLocation id;
    ResearchNode main;
    ResearchNode branch;
    ResearchNode next;
    HexHalfResult pos;
    SpellResearch data;

    ResearchNode(ResearchTree tree, Holder<HexGraphData> hex) {
        this.tree = tree;
        this.hex = hex;
        this.id = ((ResourceKey)hex.unwrapKey().orElseThrow()).location();
        this.data = tree.data.get(this.id);
    }

    public void add(ResearchDependency.Type type, ResearchNode node) {
        switch (type) {
            case MAIN: {
                if (this.main != null) {
                    return;
                }
                this.main = node;
                break;
            }
            case BRANCH: {
                if (this.branch != null) {
                    return;
                }
                this.branch = node;
                break;
            }
            case NEXT: {
                if (this.next != null) {
                    return;
                }
                this.next = node;
            }
        }
    }

    public void init(int x, int y) {
        this.pos = new HexHalfResult(y, x);
        if (this.tree.locatedNodes.containsKey(this.pos)) {
            return;
        }
        this.tree.locatedNodes.put(this.pos, this);
        if (this.main != null) {
            this.main.init(x + 1, y);
        }
        if (this.branch != null) {
            this.branch.init(x, y + 1);
        }
        if (this.next != null) {
            this.next.init(x + 1, y - 1);
        }
    }

    public double getX() {
        return this.tree.getX(this.pos.row(), this.pos.cell());
    }

    public double getY() {
        return this.tree.getY(this.pos.row(), this.pos.cell());
    }

    public Item getIcon() {
        return ((HexGraphData)this.hex.value()).icon();
    }

    public boolean unlocked() {
        return this.data.usable();
    }
}

