/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.client.graph;

import dev.xkmc.glimmeringtales.content.research.client.base.WindowBox;
import dev.xkmc.glimmeringtales.content.research.client.graph.HexGraphGui;
import dev.xkmc.glimmeringtales.content.research.client.graph.HexResultGui;
import dev.xkmc.glimmeringtales.content.research.client.graph.HexStatus;
import dev.xkmc.glimmeringtales.content.research.client.tree.ResearchTreeScreen;
import dev.xkmc.glimmeringtales.content.research.core.ResearchState;
import dev.xkmc.glimmeringtales.content.research.core.SpellResearch;
import dev.xkmc.glimmeringtales.content.research.logic.HexCell;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class MagicHexScreen
extends Screen {
    private static final Component TITLE = Component.empty();
    public final Screen parent;
    public final SpellResearch product;
    public final HexGraphGui graph;
    public final HexResultGui result;
    public HexStatus.Save save = HexStatus.Save.YES;
    public HexStatus.Compile compile = HexStatus.Compile.EDITING;
    private double accurate_mouse_x;
    private double accurate_mouse_y;
    private boolean isScrolling = false;

    public MagicHexScreen(Screen prev, SpellResearch product) {
        super(TITLE);
        this.parent = prev;
        this.product = product;
        this.graph = new HexGraphGui(this);
        this.result = new HexResultGui(this);
    }

    public void init() {
        int sw = this.width;
        int sh = this.height;
        int h = (int)(Math.min((double)sw / 300.0, (double)sh / 200.0) * 150.0);
        int w = (int)((double)h * 1.5);
        int x0 = (sw - w) / 2;
        int y0 = (sh - h) / 2;
        this.graph.box.setSize(this, x0, y0, h, h, 8);
        this.graph.initScale();
        this.result.box.setSize(this, x0 + h, y0, h / 2, h, 8);
        if (this.product.usable()) {
            this.graph.compile();
            this.updated();
        }
    }

    public void render(GuiGraphics g, int mx, int my, float partial) {
        int col_bg = -4144960;
        int col_m0 = -8355712;
        int col_m1 = -1;
        super.renderBackground(g, mx, my, partial);
        super.render(g, 0, 0, partial);
        if (Math.abs(this.accurate_mouse_x - (double)mx) > 1.0) {
            this.accurate_mouse_x = mx;
        }
        if (Math.abs(this.accurate_mouse_y - (double)my) > 1.0) {
            this.accurate_mouse_y = my;
        }
        this.graph.box.render(g, 0, col_bg, WindowBox.RenderType.FILL);
        this.graph.box.startClip(g);
        this.graph.render(g, this.accurate_mouse_x, this.accurate_mouse_y, partial);
        this.graph.box.endClip(g);
        this.graph.box.render(g, 8, col_m1, WindowBox.RenderType.MARGIN);
        this.graph.box.render(g, 2, col_m0, WindowBox.RenderType.MARGIN);
        this.result.box.render(g, 0, col_bg, WindowBox.RenderType.FILL);
        this.result.render(g, this.accurate_mouse_x, this.accurate_mouse_y, partial);
        this.result.box.render(g, 8, col_m1, WindowBox.RenderType.MARGIN);
        this.result.box.render(g, 2, col_m0, WindowBox.RenderType.MARGIN);
        this.graph.renderHover(g, mx, my);
    }

    public void tick() {
        super.tick();
        this.result.tick();
        this.graph.tick();
    }

    public void mouseMoved(double mx, double my) {
        if (this.isScrolling) {
            return;
        }
        this.accurate_mouse_x = mx;
        this.accurate_mouse_y = my;
    }

    public boolean mouseDragged(double x0, double y0, int button, double dx, double dy) {
        if (button != 0) {
            this.isScrolling = false;
            return false;
        }
        if (this.graph.box.isMouseIn(x0, y0, 0)) {
            this.isScrolling = true;
            this.graph.scroll(dx, dy);
            return true;
        }
        if (this.result.box.isMouseIn(x0, y0, 0)) {
            return this.result.mouseDragged(x0, y0, button, dx, dy);
        }
        return false;
    }

    public boolean mouseReleased(double x0, double y0, int button) {
        if (this.result.mouseReleased(x0, y0, button)) {
            return true;
        }
        return super.mouseReleased(x0, y0, button);
    }

    public boolean mouseClicked(double mx, double my, int button) {
        if (this.graph.box.isMouseIn(mx, my, 0) && this.graph.mouseClicked(mx, my, button)) {
            return true;
        }
        return super.mouseClicked(mx, my, button);
    }

    public boolean mouseScrolled(double mx, double my, double ignored, double amount) {
        if (this.graph.box.isMouseIn(mx, my, 0) && this.graph.mouseScrolled(mx, my, amount)) {
            return true;
        }
        return super.mouseScrolled(mx, my, amount, ignored);
    }

    public boolean charTyped(char ch, int type) {
        if (this.graph.charTyped(ch)) {
            return true;
        }
        return super.charTyped(ch, type);
    }

    protected void updated() {
        this.save();
    }

    private void save() {
        this.save = HexStatus.Save.NO;
        boolean pass = this.test();
        this.getCost();
        if (this.product.getState() == ResearchState.COMPLETED) {
            if (!pass) {
                return;
            }
            if (this.result.cost > this.product.getCost()) {
                return;
            }
        }
        this.forceSave(pass);
    }

    void forceSave(boolean pass) {
        this.save = HexStatus.Save.YES;
        this.product.updateBestSolution(this.graph.handler, this.result.data, pass ? this.result.cost : -1);
        this.product.save();
    }

    private boolean test() {
        this.compile = HexStatus.Compile.EDITING;
        if (this.graph.error != null) {
            this.compile = HexStatus.Compile.ERROR;
        }
        if (this.graph.flow != null) {
            this.compile = HexStatus.Compile.FAILED;
            boolean ans = this.graph.check(this.result.data, this.product.getGraph());
            if (ans) {
                this.compile = HexStatus.Compile.COMPLETE;
            }
            return ans;
        }
        return false;
    }

    private void getCost() {
        this.result.cost = 0;
        HexCell cell = new HexCell(this.graph.handler, 0, 0);
        cell.row = 0;
        while (cell.row < this.graph.handler.getRowCount()) {
            cell.cell = 0;
            while (cell.cell < this.graph.handler.getCellCount(cell.row)) {
                if (cell.exists()) {
                    ++this.result.cost;
                }
                ++cell.cell;
            }
            ++cell.row;
        }
    }

    public boolean keyPressed(int key, int scan, int modifier) {
        return super.keyPressed(key, scan, modifier);
    }

    public void onClose() {
        if (this.minecraft != null && this.minecraft.screen == this && this.parent != null) {
            this.minecraft.setScreen(this.parent);
            Screen screen = this.parent;
            if (screen instanceof ResearchTreeScreen) {
                ResearchTreeScreen tree = (ResearchTreeScreen)screen;
                tree.focusOn(this.product);
            }
        }
    }
}

