/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.client.graph;

import dev.xkmc.glimmeringtales.content.core.spell.SpellElement;
import dev.xkmc.glimmeringtales.content.research.client.base.AbstractHexGui;
import dev.xkmc.glimmeringtales.content.research.client.base.WindowBox;
import dev.xkmc.glimmeringtales.content.research.client.graph.HexRenderUtil;
import dev.xkmc.glimmeringtales.content.research.client.graph.MagicHexScreen;
import dev.xkmc.glimmeringtales.content.research.core.HexGraph;
import dev.xkmc.glimmeringtales.content.research.core.HexOrder;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class HexResultGui {
    private static final int FLOW_COUNT = 5;
    private static final int PERIOD = 60;
    private static final float SCALE_NODE = 1.0f;
    private static final float SCALE_FLOW = 0.2f;
    private final Minecraft minecraft = Minecraft.getInstance();
    private final MagicHexScreen screen;
    private final HexGraph graph;
    private int selected = -1;
    private double sele_x = 0.0;
    private double sele_y = 0.0;
    private int tick = 0;
    private boolean isDragging = false;
    int cost = 0;
    final HexOrder data;
    final WindowBox box = new WindowBox();

    public HexResultGui(MagicHexScreen screen) {
        this.screen = screen;
        this.graph = screen.product.getGraph();
        this.data = screen.product.getMiscData();
    }

    private float getScaleNode() {
        return (float)this.box.w / 100.0f;
    }

    private float getScaleFlow() {
        return 0.2f * (float)this.box.w / 100.0f;
    }

    private float radius() {
        return (float)(30 * this.box.w) / 100.0f;
    }

    public void render(GuiGraphics g, double mx, double my, float partial) {
        double yi;
        double xi;
        int i;
        float progress = ((float)this.tick + partial) / 60.0f % 1.0f;
        float x0 = (float)this.box.x + (float)this.box.w / 2.0f;
        float y0 = (float)this.box.y + (float)this.box.w / 2.0f;
        int hover = this.within(mx, my);
        for (i = 0; i < 6; ++i) {
            double ri = (double)i * Math.PI / 3.0;
            double xi2 = (double)x0 + (double)this.radius() * Math.cos(ri);
            double yi2 = (double)y0 + (double)this.radius() * Math.sin(ri);
            int color = i == hover ? -8355712 : -1;
            HexRenderUtil.renderHex(g, xi2, yi2, 10.0f * this.getScaleNode(), color);
        }
        for (i = 0; i < 6; ++i) {
            SpellElement elem = this.getElem(i);
            if (elem == null) continue;
            xi = this.getX(i);
            yi = this.getY(i);
            for (int j = 0; j < 6; ++j) {
                if (this.getElem(j) == null || !this.graph.connected(this.data.order()[i], this.data.order()[j])) continue;
                double xj = this.getX(j);
                double yj = this.getY(j);
                for (int k = 0; k < 5; ++k) {
                    double p = ((double)progress + (double)k * 1.0 / 5.0) % 1.0;
                    double xp = xi + (xj - xi) * p;
                    double yp = yi + (yj - yi) * p;
                    AbstractHexGui.drawIcon(g, elem.getIcon(), xp, yp, this.getScaleFlow());
                }
            }
        }
        for (i = 0; i < 6; ++i) {
            SpellElement elem = this.getElem(i);
            if (elem == null) continue;
            xi = this.getX(i);
            yi = this.getY(i);
            AbstractHexGui.drawIcon(g, elem.getIcon(), xi, yi, this.getScaleNode());
        }
        int hi = this.box.y + this.box.w + 36;
        Font font = this.minecraft.font;
        g.drawString(font, (Component)this.screen.save.getDesc(), this.box.x + 9, hi, this.screen.save.getColor(), false);
        g.drawString(font, (Component)this.screen.compile.getDesc(), this.box.x + 9, hi + 9, this.screen.compile.getColor(), false);
        g.drawString(font, (Component)GTLang.HEX_COST.get(this.cost), this.box.x + 9, hi + 18, -16777216, false);
    }

    @Nullable
    SpellElement getElem(int i) {
        return this.data.getElem(this.graph, i);
    }

    private double getX(int i) {
        if (this.isDragging && this.selected == i) {
            return this.sele_x;
        }
        double ri = (double)i * Math.PI / 3.0;
        float x0 = (float)this.box.x + (float)this.box.w / 2.0f;
        return (double)x0 + (double)this.radius() * Math.cos(ri);
    }

    private double getY(int i) {
        if (this.isDragging && this.selected == i) {
            return this.sele_y;
        }
        double ri = (double)i * Math.PI / 3.0;
        float y0 = (float)this.box.y + (float)this.box.w / 2.0f;
        return (double)y0 + (double)this.radius() * Math.sin(ri);
    }

    public void tick() {
        ++this.tick;
        this.tick %= 60;
    }

    public boolean mouseDragged(double x0, double y0, int button, double dx, double dy) {
        if (!this.isDragging) {
            this.isDragging = true;
            int i = this.within(x0, y0);
            if (i >= 0 && this.getElem(i) != null) {
                this.selected = i;
            }
        }
        if (this.selected != -1) {
            this.sele_x = x0;
            this.sele_y = y0;
        }
        return false;
    }

    public boolean mouseReleased(double x0, double y0, int button) {
        if (this.isDragging) {
            int i;
            this.isDragging = false;
            if (this.selected != -1 && (i = this.within(x0, y0)) >= 0) {
                int elem = this.data.order()[i];
                this.data.order()[i] = this.data.order()[this.selected];
                this.data.order()[this.selected] = elem;
                this.screen.updated();
            }
            this.selected = -1;
            return true;
        }
        return false;
    }

    private int within(double mx, double my) {
        float x0 = (float)this.box.x + (float)this.box.w / 2.0f;
        float y0 = (float)this.box.y + (float)this.box.w / 2.0f;
        for (int i = 0; i < 6; ++i) {
            double ri = (double)i * Math.PI / 3.0;
            double xi = (double)x0 + (double)this.radius() * Math.cos(ri);
            double yi = (double)y0 + (double)this.radius() * Math.sin(ri);
            if (!(mx > xi - 8.0) || !(mx < xi + 8.0) || !(my > yi - 8.0) || !(my < yi + 8.0)) continue;
            return i;
        }
        return -1;
    }
}

