/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.client.graph;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.IntConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class HexRenderUtil {
    public static boolean vert_strip = true;
    public static boolean time_shift = true;
    public static final float SHIFT_WIDTH = 0.2f;
    public static final float SHIFT_PERIOD = 60.0f;
    private static BufferBuilder builder;
    private static Matrix4f last;
    private static Op op;
    static float ca;
    static float cr;
    static float cg;
    static float cb;
    static float cx;
    static float cy;
    static float lx;
    static float ly;
    static float wx;
    static float wy;
    static float peak;
    static float plen;
    static float time;
    static double width;
    static double length;
    static double r;
    static double x;
    static double y;
    static int offset;
    static boolean focus;

    public static void common_end() {
        MeshData ans = builder.build();
        if (ans != null) {
            BufferUploader.drawWithShader((MeshData)ans);
        }
        ca = 1.0f;
        op = null;
    }

    static void flow_setup(GuiGraphics g, int color, double w, double l, float t, int off, double radius, boolean foc) {
        if (op != null) {
            throw new RuntimeException("op is " + String.valueOf((Object)op) + ", expected null");
        }
        op = Op.FLOW;
        last = g.pose().last().pose();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        width = w;
        length = l;
        time = t;
        offset = off;
        r = radius;
        focus = foc;
        cr = (float)(color >> 16 & 0xFF) / 255.0f;
        cg = (float)(color >> 8 & 0xFF) / 255.0f;
        cb = (float)(color & 0xFF) / 255.0f;
        peak = (float)(width / Math.sqrt(3.0) / length);
        plen = 0.1f;
    }

    static void flow_path(double x, double y, int dire, int mask) {
        if (op != Op.FLOW) {
            throw new RuntimeException("op is " + String.valueOf((Object)op) + ", expected FLOW");
        }
        double a = (double)dire * Math.PI / 3.0;
        cx = (float)(x + r * Math.cos(a) / 2.0);
        cy = (float)(y + r * Math.sin(a) / 2.0);
        lx = (float)(length / 2.0 * Math.cos(a));
        ly = (float)(length / 2.0 * Math.sin(a));
        wx = (float)(width / 2.0 * Math.cos(a - 1.5707963267948966));
        wy = (float)(width / 2.0 * Math.sin(a - 1.5707963267948966));
        int n = focus ? 4 : 2;
        for (int i = 0; i < n; ++i) {
            HexRenderUtil.flow_strip((time / 10.0f / (float)n + (float)offset * 0.1f + 1.0f / (float)n * (float)i) % 1.0f, plen, peak, mask);
        }
    }

    private static void flow_strip(float p0, float plen, float peak, int mask) {
        if (p0 + plen < 1.0f) {
            if ((mask & 1) > 0) {
                HexRenderUtil.flow_rect(p0, p0 + plen, peak);
            }
            if ((mask & 2) > 0) {
                HexRenderUtil.flow_rect(1.0f - (p0 + plen), 1.0f - p0, -peak);
            }
        } else {
            if ((mask & 1) > 0) {
                HexRenderUtil.flow_rect(p0, 1.0f, peak);
                HexRenderUtil.flow_rect(0.0f, p0 + plen - 1.0f, peak);
            }
            if ((mask & 2) > 0) {
                HexRenderUtil.flow_rect(0.0f, 1.0f - p0, -peak);
                HexRenderUtil.flow_rect(2.0f - (p0 + plen), 1.0f, -peak);
            }
        }
    }

    private static void flow_rect(float p0, float p1, float peak) {
        if (focus || peak > 0.0f) {
            HexRenderUtil.flow_point(1, p1, 0.0f);
            HexRenderUtil.flow_point(1, p0, 0.0f);
            HexRenderUtil.flow_point(0, p0, peak);
            HexRenderUtil.flow_point(0, p1, peak);
        }
        if (focus || peak < 0.0f) {
            HexRenderUtil.flow_point(0, p1, peak);
            HexRenderUtil.flow_point(0, p0, peak);
            HexRenderUtil.flow_point(-1, p0, 0.0f);
            HexRenderUtil.flow_point(-1, p1, 0.0f);
        }
    }

    private static void flow_point(int sign, float p, float peak) {
        builder.addVertex(last, cx + (p * 2.0f - 1.0f + peak) * lx + (float)sign * wx, cy + (p * 2.0f - 1.0f + peak) * ly + (float)sign * wy, 0.0f).setColor(cr, cg, cb, 1.0f);
    }

    public static void path_start(GuiGraphics g, double w, double l, double radius, float t) {
        if (op != null) {
            throw new RuntimeException("op is " + String.valueOf((Object)op) + ", expected null");
        }
        op = Op.PATH;
        last = g.pose().last().pose();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        width = w;
        length = l;
        r = radius;
        time = t;
    }

    static void path(double x, double y, int dire, int[] colors, int n) {
        if (op != Op.PATH) {
            throw new RuntimeException("op is " + String.valueOf((Object)op) + ", expected PATH");
        }
        double a = (double)dire * Math.PI / 3.0;
        cx = (float)(x + r * Math.cos(a) / 2.0);
        cy = (float)(y + r * Math.sin(a) / 2.0);
        lx = (float)(length / 2.0 * Math.cos(a));
        ly = (float)(length / 2.0 * Math.sin(a));
        wx = (float)(width / 2.0 * Math.cos(a - 1.5707963267948966));
        wy = (float)(width / 2.0 * Math.sin(a - 1.5707963267948966));
        for (int i = 0; i < n; ++i) {
            int col = colors[i];
            HexRenderUtil.path_color(col, 1.0f / (float)n * (float)i, 1.0f / (float)n * (float)(i + 1));
        }
    }

    public static void path(double x, double y, int dire, int color) {
        if (op != Op.PATH) {
            throw new RuntimeException("op is " + String.valueOf((Object)op) + ", expected PATH");
        }
        double a = (double)dire * Math.PI / 3.0;
        cx = (float)(x + r * Math.cos(a) / 2.0);
        cy = (float)(y + r * Math.sin(a) / 2.0);
        lx = (float)(length / 2.0 * Math.cos(a));
        ly = (float)(length / 2.0 * Math.sin(a));
        wx = (float)(width / 2.0 * Math.cos(a - 1.5707963267948966));
        wy = (float)(width / 2.0 * Math.sin(a - 1.5707963267948966));
        HexRenderUtil.path_color(color, 0.0f, 1.0f);
    }

    private static void path_color(int color, float left, float right) {
        if (time_shift && (left != 0.0f || right != 1.0f)) {
            float t0 = time / 60.0f % 1.0f;
            if (t0 + 0.2f > 1.0f) {
                if (left < t0 + 0.2f - 1.0f) {
                    t0 -= 1.0f;
                } else if (right < t0) {
                    return;
                }
            }
            if ((left = Mth.clamp((float)((left - t0) / 0.2f), (float)0.0f, (float)1.0f)) == (right = Mth.clamp((float)((right - t0) / 0.2f), (float)0.0f, (float)1.0f))) {
                return;
            }
        }
        cr = (float)(color >> 16 & 0xFF) / 255.0f;
        cg = (float)(color >> 8 & 0xFF) / 255.0f;
        cb = (float)(color & 0xFF) / 255.0f;
        float ll = 0.0f;
        float lr = 1.0f;
        float wl = 0.0f;
        float wr = 1.0f;
        if (vert_strip) {
            wl = left;
            wr = right;
        } else {
            ll = left;
            lr = right;
        }
        float alx = lx * (lr * 2.0f - 1.0f);
        float aly = ly * (lr * 2.0f - 1.0f);
        float blx = lx * (ll * 2.0f - 1.0f);
        float bly = ly * (ll * 2.0f - 1.0f);
        float awx = wx * (wr * 2.0f - 1.0f);
        float awy = wy * (wr * 2.0f - 1.0f);
        float bwx = wx * (wl * 2.0f - 1.0f);
        float bwy = wy * (wl * 2.0f - 1.0f);
        HexRenderUtil.path_point(cx + alx + awx, cy + aly + awy);
        HexRenderUtil.path_point(cx + blx + awx, cy + bly + awy);
        HexRenderUtil.path_point(cx + blx + bwx, cy + bly + bwy);
        HexRenderUtil.path_point(cx + alx + bwx, cy + aly + bwy);
    }

    private static void path_point(float x, float y) {
        builder.addVertex(last, x, y, 0.0f).setColor(cr, cg, cb, 1.0f);
    }

    public static void hex_start(GuiGraphics g) {
        if (op != null) {
            throw new RuntimeException("op is " + String.valueOf((Object)op) + ", expected null");
        }
        op = Op.HEX;
        last = g.pose().last().pose();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
    }

    public static void hex(double xpos, double ypos, double radius, int color) {
        if (op != Op.HEX) {
            throw new RuntimeException("op is " + String.valueOf((Object)op) + ", expected HEX");
        }
        cr = (float)(color >> 16 & 0xFF) / 255.0f;
        cg = (float)(color >> 8 & 0xFF) / 255.0f;
        cb = (float)(color & 0xFF) / 255.0f;
        x = xpos;
        y = ypos;
        r = radius;
        HexRenderUtil.hex_point(0);
        HexRenderUtil.hex_point(3);
        HexRenderUtil.hex_point(2);
        HexRenderUtil.hex_point(1);
        HexRenderUtil.hex_point(0);
        HexRenderUtil.hex_point(5);
        HexRenderUtil.hex_point(4);
        HexRenderUtil.hex_point(3);
    }

    private static void hex_point(int i) {
        double a = ((double)i + 0.5) * Math.PI / 3.0;
        float px = (float)(x + r * Math.cos(a));
        float py = (float)(y + r * Math.sin(a));
        builder.addVertex(last, px, py, 0.0f).setColor(cr, cg, cb, ca);
    }

    static void renderHex(GuiGraphics g, double x, double y, double r, int color) {
        Matrix4f last = g.pose().last().pose();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float ca = (float)(color >> 24 & 0xFF) / 255.0f;
        float cr = (float)(color >> 16 & 0xFF) / 255.0f;
        float cg = (float)(color >> 8 & 0xFF) / 255.0f;
        float cb = (float)(color & 0xFF) / 255.0f;
        IntConsumer c = i -> {
            double a = ((double)i + 0.5) * Math.PI / 3.0;
            float px = (float)(x + r * Math.cos(a));
            float py = (float)(y + r * Math.sin(a));
            builder.addVertex(last, px, py, 0.0f).setColor(cr, cg, cb, ca);
        };
        c.accept(0);
        c.accept(3);
        c.accept(2);
        c.accept(1);
        c.accept(0);
        c.accept(5);
        c.accept(4);
        c.accept(3);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    static {
        op = null;
        ca = 1.0f;
        focus = false;
    }

    static enum Op {
        FLOW,
        PATH,
        HEX;

    }
}

