/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.client.graph;

import dev.xkmc.glimmeringtales.content.core.spell.SpellElement;
import dev.xkmc.glimmeringtales.content.research.client.base.AbstractHexGui;
import dev.xkmc.glimmeringtales.content.research.client.base.AbstractScalableGui;
import dev.xkmc.glimmeringtales.content.research.client.graph.HexRenderUtil;
import dev.xkmc.glimmeringtales.content.research.client.graph.HexStatus;
import dev.xkmc.glimmeringtales.content.research.client.graph.MagicHexScreen;
import dev.xkmc.glimmeringtales.content.research.core.HexGraph;
import dev.xkmc.glimmeringtales.content.research.core.HexOrder;
import dev.xkmc.glimmeringtales.content.research.logic.ArrowResult;
import dev.xkmc.glimmeringtales.content.research.logic.CellResult;
import dev.xkmc.glimmeringtales.content.research.logic.FlowChart;
import dev.xkmc.glimmeringtales.content.research.logic.Frac;
import dev.xkmc.glimmeringtales.content.research.logic.HexCalcException;
import dev.xkmc.glimmeringtales.content.research.logic.HexCell;
import dev.xkmc.glimmeringtales.content.research.logic.HexDirection;
import dev.xkmc.glimmeringtales.content.research.logic.HexHandler;
import dev.xkmc.glimmeringtales.content.research.logic.LocateResult;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class HexGraphGui
extends AbstractScalableGui {
    private static final int PERIOD = 60;
    private static final double MARGIN = 0.9;
    private static final double RADIUS = 2.0 / Math.sqrt(3.0);
    private static final int COL_BG = -8355712;
    private static final int COL_ENABLED = -1;
    private static final int COL_DISABLED = -12566464;
    private static final int COL_HOVER = -256;
    private static final int COL_ERROR = -65536;
    private static final int COL_FLOW = -129;
    private final MagicHexScreen screen;
    private final Map<SpellElement, Integer> ELEM_2_ID = new HashMap<SpellElement, Integer>();
    HexHandler handler;
    FlowChart flow = null;
    boolean[] wrong_flow = new boolean[6];
    boolean[] ignore = new boolean[6];
    protected HexCalcException error = null;
    protected HexDirection selected = null;
    private int tick;

    private static int getFlowColor(double val) {
        if (val <= 1.0) {
            val = Math.pow(val, 0.5);
            int col = (int)((1.0 - val) * 255.0);
            return 0xFF0000FF | col << 16 | col << 8;
        }
        val = Math.pow(val, 1.0);
        int col = (int)(255.0 / val);
        return 0xFF000000 | 255 - col << 16 | col;
    }

    public HexGraphGui(MagicHexScreen screen) {
        this.screen = screen;
        this.handler = screen.product.getSolution();
        GTRegistries.ELEMENT.get().forEach(a -> this.ELEM_2_ID.put((SpellElement)((Object)a), this.ELEM_2_ID.size()));
    }

    @Override
    public void initScale() {
        this.magn = (float)Math.min(this.box.w, this.box.h) / 2.0f / (float)(this.getRadius() * 2 + 1);
    }

    public void render(GuiGraphics g, double mx, double my, float partial) {
        double x0 = (double)this.box.x + (double)this.box.w / 2.0;
        double y0 = (double)this.box.y + (double)this.box.h / 2.0;
        g.pose().pushPose();
        g.pose().translate(x0 + this.scrollX, y0 + this.scrollY, 0.0);
        LocateResult hover = this.handler.getElementOnHex(this.getMX(mx), this.getMY(my));
        this.renderBG(g, hover);
        double ratio = 0.25;
        double width = RADIUS * ratio * (double)this.magn;
        double length = 2.0 * (1.0 - ratio) * (double)this.magn;
        this.renderPath(g, width, length, true);
        width = RADIUS * (ratio *= 0.5) * (double)this.magn;
        length = 2.0 * (1.0 - ratio) * (double)this.magn;
        this.renderPath(g, width, length, false);
        this.renderFlow(g, width, length, partial);
        this.renderError(g, width, length);
        this.renderIcons(g);
        g.pose().popPose();
    }

    public void renderHover(GuiGraphics g, double mx, double my) {
        LocateResult hover = this.handler.getElementOnHex(this.getMX(mx), this.getMY(my));
        this.renderTooltip(g, (int)mx, (int)my, hover);
    }

    public void setRadius(int radius) {
        this.handler = new HexHandler(radius);
    }

    public int getRadius() {
        return this.handler.radius;
    }

    public boolean mouseClicked(double mx, double my, int button) {
        LocateResult hover;
        if (button == 0 && this.click(hover = this.handler.getElementOnHex(this.getMX(mx), this.getMY(my)))) {
            this.flow = null;
            this.error = null;
            this.screen.compile = HexStatus.Compile.EDITING;
            this.screen.updated();
            return true;
        }
        return false;
    }

    private boolean click(@Nullable LocateResult hover) {
        if (hover == null) {
            return false;
        }
        if (hover.getType() == LocateResult.ResultType.ARROW) {
            ArrowResult res = (ArrowResult)hover;
            new HexCell(this.handler, res.row, res.cell).toggle(res.dir);
            return true;
        }
        if (hover.getType() == LocateResult.ResultType.CELL) {
            CellResult res = (CellResult)hover;
            HexCell cell = new HexCell(this.handler, res.getRow(), res.getCell());
            if (this.flow == null) {
                for (HexDirection dire : HexDirection.values()) {
                    if (!cell.canWalk(dire) || !cell.isConnected(dire)) continue;
                    cell.toggle(dire);
                }
                return true;
            }
            if (cell.isCorner()) {
                this.selected = this.selected == cell.getCorner() ? null : cell.getCorner();
                return false;
            }
        }
        return false;
    }

    public void tick() {
        ++this.tick;
        this.tick %= 60;
    }

    public boolean charTyped(char ch) {
        if (ch == 'r') {
            this.compile();
            this.screen.updated();
            return true;
        }
        if (ch == '=' && this.handler.radius < 7) {
            this.setRadius(this.handler.radius + 1);
            this.flow = null;
            this.error = null;
            this.screen.updated();
        } else if (ch == '-' && this.handler.radius > 2) {
            this.setRadius(this.handler.radius - 1);
            this.flow = null;
            this.error = null;
            this.screen.updated();
        }
        if (!Minecraft.getInstance().player.isCreative()) {
            return false;
        }
        if (ch == 'f') {
            this.screen.forceSave(false);
            return true;
        }
        return false;
    }

    void compile() {
        this.flow = null;
        this.error = null;
        try {
            this.flow = this.handler.getMatrix(true);
        }
        catch (HexCalcException e) {
            this.flow = null;
            this.error = e;
        }
        catch (Exception e) {
            this.flow = null;
            this.error = null;
            LogManager.getLogger().throwing((Throwable)e);
        }
    }

    boolean check(HexOrder order, HexGraph graph) {
        return order.check(this.handler, this.flow, graph, this.wrong_flow, this.ignore);
    }

    private void renderBG(GuiGraphics g, @Nullable LocateResult hover) {
        HexRenderUtil.hex_start(g);
        HexCell cell = new HexCell(this.handler, 0, 0);
        cell.row = 0;
        while (cell.row < this.handler.getRowCount()) {
            cell.cell = 0;
            while (cell.cell < this.handler.getCellCount(cell.row)) {
                double x = cell.getX() * (double)this.magn;
                double y = cell.getY() * (double)this.magn;
                double r = 0.9 * RADIUS * (double)this.magn;
                HexRenderUtil.hex(x, y, r, -8355712);
                ++cell.cell;
            }
            ++cell.row;
        }
        if (hover != null) {
            HexRenderUtil.hex(hover.getX() * (double)this.magn, hover.getY() * (double)this.magn, RADIUS * (double)this.magn / 2.0, -256);
        }
        HexRenderUtil.common_end();
    }

    private void renderPath(GuiGraphics g, double width, double length, boolean render_off) {
        int col;
        double y;
        double x;
        HexCell cell = new HexCell(this.handler, 0, 0);
        HexRenderUtil.path_start(g, width, length, 2.0 * (double)this.magn, 0.0f);
        cell.row = 0;
        while (cell.row < this.handler.getRowCount()) {
            cell.cell = 0;
            while (cell.cell < this.handler.getCellCount(cell.row)) {
                x = cell.getX() * (double)this.magn;
                y = cell.getY() * (double)this.magn;
                for (int i = 0; i < 3; ++i) {
                    HexDirection dire = HexDirection.values()[i];
                    if (!cell.canWalk(dire)) continue;
                    int n = col = cell.isConnected(dire) ? -1 : -12566464;
                    if (!render_off && !cell.isConnected(dire)) continue;
                    HexRenderUtil.path(x, y, i, col);
                }
                ++cell.cell;
            }
            ++cell.row;
        }
        HexRenderUtil.common_end();
        HexRenderUtil.hex_start(g);
        cell.row = 0;
        while (cell.row < this.handler.getRowCount()) {
            cell.cell = 0;
            while (cell.cell < this.handler.getCellCount(cell.row)) {
                x = cell.getX() * (double)this.magn;
                y = cell.getY() * (double)this.magn;
                int n = col = cell.exists() ? -1 : -12566464;
                if (render_off || cell.exists()) {
                    HexRenderUtil.hex(x, y, width, col);
                }
                ++cell.cell;
            }
            ++cell.row;
        }
        HexRenderUtil.common_end();
    }

    private void renderFlow(GuiGraphics g, double width, double length, float partial) {
        if (this.flow == null) {
            return;
        }
        int[] masks = new int[6];
        int[] col_masks = new int[6];
        for (int i = 0; i < 6; ++i) {
            SpellElement elem = this.screen.result.getElem(i);
            if (elem == null || this.ignore[i]) continue;
            masks[i] = 1 << this.ELEM_2_ID.get((Object)elem);
            col_masks[this.ELEM_2_ID.get((Object)((Object)elem)).intValue()] = elem.getColor();
        }
        HexCell cell = new HexCell(this.handler, 0, 0);
        double[][] vals = new double[this.handler.getRowCount()][];
        int[][] node_masks = new int[this.handler.getRowCount()][];
        cell.row = 0;
        while (cell.row < this.handler.getRowCount()) {
            vals[cell.row] = new double[this.handler.getCellCount(cell.row)];
            node_masks[cell.row] = new int[this.handler.getCellCount(cell.row)];
            ++cell.row;
        }
        HexRenderUtil.path_start(g, width, length, 2.0 * (double)this.magn, (float)this.tick + partial);
        this.renderFlowBase(masks, col_masks, vals, node_masks);
        HexRenderUtil.common_end();
        this.renderFlowSelected(g, width, length, partial, this.selected);
        this.renderFlowNode(g, vals, node_masks, col_masks, width);
    }

    private void renderFlowBase(int[] masks, int[] col_masks, double[][] vals, int[][] node_masks) {
        HexCell cell = new HexCell(this.handler, 0, 0);
        int[] cols = new int[6];
        for (FlowChart.Flow f : this.flow.flows) {
            int dire;
            double y;
            double x;
            cell.row = f.arrow.row;
            cell.cell = f.arrow.cell;
            if (this.selected == null) {
                int mask = 0;
                Frac[] forward = f.forward;
                for (int i = 0; i < forward.length; ++i) {
                    Frac fr = forward[i];
                    if (fr == null) continue;
                    mask |= masks[i];
                }
                Frac[] backward = f.backward;
                for (int i = 0; i < backward.length; ++i) {
                    Frac fr = backward[i];
                    if (fr == null) continue;
                    mask |= masks[i];
                }
                int[] nArray = node_masks[cell.row];
                int n = cell.cell;
                nArray[n] = nArray[n] | mask;
                x = cell.getX() * (double)this.magn;
                y = cell.getY() * (double)this.magn;
                dire = f.arrow.dir.ind;
                int n2 = 0;
                for (int i = 0; i < 6; ++i) {
                    if ((mask & 1 << i) <= 0) continue;
                    cols[n2] = col_masks[i];
                    ++n2;
                }
                HexRenderUtil.path(x, y, dire, cols, n2);
                cell.walk(f.arrow.dir);
                int[] nArray2 = node_masks[cell.row];
                int n3 = cell.cell;
                nArray2[n3] = nArray2[n3] | mask;
                continue;
            }
            double val = 0.0;
            if (!this.ignore[this.selected.ind] && f.forward[this.selected.ind] != null) {
                double fval = f.forward[this.selected.ind].getVal();
                this.updateNodeVal(vals, cell, f.arrow.dir, fval);
                val += fval;
            }
            if (!this.ignore[this.selected.ind] && f.backward[this.selected.ind] != null) {
                double bval = f.backward[this.selected.ind].getVal();
                this.updateNodeVal(vals, cell, f.arrow.dir, bval);
                val += bval;
            }
            int col = HexGraphGui.getFlowColor(val);
            x = cell.getX() * (double)this.magn;
            y = cell.getY() * (double)this.magn;
            dire = f.arrow.dir.ind;
            HexRenderUtil.path(x, y, dire, col);
        }
    }

    private void renderFlowSelected(GuiGraphics g, double width, double length, float partial, @Nullable HexDirection sel) {
        if (sel == null) {
            return;
        }
        SpellElement elem = this.screen.result.getElem(sel.ind);
        if (elem == null || this.selected != null && this.selected != sel) {
            return;
        }
        int offset = this.ELEM_2_ID.get((Object)elem);
        HexCell cell = new HexCell(this.handler, 0, 0);
        HexRenderUtil.flow_setup(g, elem.getColor(), width, length, (float)this.tick + partial, offset, 2.0 * (double)this.magn, this.selected != null);
        for (FlowChart.Flow f : this.flow.flows) {
            double bval;
            double fval;
            int mask = 0;
            cell.row = f.arrow.row;
            cell.cell = f.arrow.cell;
            if (!this.ignore[sel.ind] && f.forward[sel.ind] != null && (fval = f.forward[sel.ind].getVal()) > 0.0) {
                mask |= 1;
            }
            if (!this.ignore[sel.ind] && f.backward[sel.ind] != null && (bval = f.backward[sel.ind].getVal()) > 0.0) {
                mask |= 2;
            }
            double x = cell.getX() * (double)this.magn;
            double y = cell.getY() * (double)this.magn;
            int dire = f.arrow.dir.ind;
            if (mask <= 0) continue;
            HexRenderUtil.flow_path(x, y, dire, mask);
        }
        HexRenderUtil.common_end();
    }

    private void renderFlowNode(GuiGraphics g, double[][] vals, int[][] masks, int[] col_masks, double width) {
        double y;
        double x;
        HexCell cell = new HexCell(this.handler, 0, 0);
        HexRenderUtil.hex_start(g);
        cell.row = 0;
        while (cell.row < this.handler.getRowCount()) {
            cell.cell = 0;
            while (cell.cell < this.handler.getCellCount(cell.row)) {
                int col;
                x = cell.getX() * (double)this.magn;
                y = cell.getY() * (double)this.magn;
                double val = vals[cell.row][cell.cell];
                if (!cell.exists()) {
                    col = -12566464;
                } else if (this.selected == null) {
                    col = 0xB0B0B0;
                    for (int i = 0; i < 6; ++i) {
                        if (masks[cell.row][cell.cell] != 1 << i) continue;
                        col = col_masks[i];
                    }
                } else {
                    col = HexGraphGui.getFlowColor(val);
                }
                HexRenderUtil.hex(x, y, width, col);
                ++cell.cell;
            }
            ++cell.row;
        }
        if (this.selected != null) {
            cell.toCorner(this.selected);
            x = cell.getX() * (double)this.magn;
            y = cell.getY() * (double)this.magn;
            HexRenderUtil.hex(x, y, width, -256);
        }
        for (int i = 0; i < 6; ++i) {
            if (!this.wrong_flow[i]) continue;
            cell.toCorner(HexDirection.values()[i]);
            double x2 = cell.getX() * (double)this.magn;
            double y2 = cell.getY() * (double)this.magn;
            HexRenderUtil.hex(x2, y2, width, -65536);
        }
        HexRenderUtil.common_end();
    }

    private void renderError(GuiGraphics g, double width, double length) {
        if (this.error != null) {
            double y;
            double x;
            HexCell cell = new HexCell(this.handler, 0, 0);
            HexRenderUtil.path_start(g, width, length, 2.0 * (double)this.magn, 0.0f);
            for (HexCalcException.Side side : this.error.error) {
                cell.row = side.row;
                cell.cell = side.cell;
                x = cell.getX() * (double)this.magn;
                y = cell.getY() * (double)this.magn;
                int dire = side.dir.ind;
                HexRenderUtil.path(x, y, dire, -65536);
                cell.walk(side.dir);
            }
            HexRenderUtil.common_end();
            HexRenderUtil.hex_start(g);
            for (HexCalcException.Side side : this.error.error) {
                cell.row = side.row;
                cell.cell = side.cell;
                x = cell.getX() * (double)this.magn;
                y = cell.getY() * (double)this.magn;
                int col = -65536;
                HexRenderUtil.hex(x, y, width, col);
                cell.walk(side.dir);
                x = cell.getX() * (double)this.magn;
                y = cell.getY() * (double)this.magn;
                HexRenderUtil.hex(x, y, width, col);
            }
            HexRenderUtil.common_end();
        }
    }

    private void renderIcons(GuiGraphics g) {
        HexCell cell = new HexCell(this.handler, 0, 0);
        for (int i = 0; i < 6; ++i) {
            SpellElement elem = this.screen.result.getElem(i);
            if (elem == null) continue;
            cell.toCorner(HexDirection.values()[i]);
            double x = cell.getX() * (double)this.magn;
            double y = cell.getY() * (double)this.magn;
            AbstractHexGui.drawIcon(g, elem.getIcon(), x, y, this.magn / 10.0f);
        }
    }

    private void renderTooltip(GuiGraphics g, int mx, int my, @Nullable LocateResult hover) {
        if (hover == null || hover.getType() != LocateResult.ResultType.ARROW || this.selected == null || this.flow == null) {
            return;
        }
        this.flow.flows.stream().filter(e -> e.arrow.equals(hover)).findFirst().ifPresent(e -> {
            ArrayList<Component> list = new ArrayList<Component>();
            if (e.forward[this.selected.ind] != null) {
                list.add((Component)e.arrow.dir.getDesc().append(e.forward[this.selected.ind].toString()));
            }
            if (e.backward[this.selected.ind] != null) {
                list.add((Component)e.arrow.dir.next(3).getDesc().append(e.backward[this.selected.ind].toString()));
            }
            if (!list.isEmpty()) {
                AbstractHexGui.drawHover(g, list, mx, my);
            }
        });
    }

    private void updateNodeVal(double[][] vals, HexCell cell, HexDirection dir, double val) {
        double[] dArray = vals[cell.row];
        int n = cell.cell;
        dArray[n] = dArray[n] + (cell.isCorner() ? val : val / 2.0);
        cell.walk(dir);
        double[] dArray2 = vals[cell.row];
        int n2 = cell.cell;
        dArray2[n2] = dArray2[n2] + (cell.isCorner() ? val : val / 2.0);
        cell.walk(dir.next(3));
    }
}

