/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.research.client.base;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class WindowBox {
    private Screen parent;
    public int x;
    public int y;
    public int w;
    public int h;
    public int margin;

    public void setSize(Screen parent, int x, int y, int w, int h, int sh) {
        this.x = x + sh;
        this.y = y + sh;
        this.w = w - sh * 2;
        this.h = h - sh * 2;
        this.margin = sh;
        this.parent = parent;
    }

    public boolean isMouseIn(double mx, double my, int sh) {
        return mx > (double)(this.x - sh) && mx < (double)(this.x + this.w + sh) && my > (double)(this.y - sh) && my < (double)(this.y + this.h + sh);
    }

    public void render(GuiGraphics g, int sh, int color, RenderType type) {
        if (type == RenderType.FILL) {
            g.fill(this.x - sh, this.y - sh, this.x + this.w + sh, this.y + this.h + sh, color);
        } else if (type == RenderType.MARGIN) {
            g.fill(this.x - sh, this.y - sh, this.x + this.w + sh, this.y, color);
            g.fill(this.x - sh, this.y + this.h, this.x + this.w + sh, this.y + this.h + sh, color);
            g.fill(this.x - sh, this.y, this.x, this.y + this.h, color);
            g.fill(this.x + this.w, this.y, this.x + this.w + sh, this.y + this.h, color);
        } else {
            g.fill(0, 0, this.parent.width, this.y, color);
            g.fill(0, this.y + this.h, this.parent.width, this.parent.height, color);
            g.fill(0, this.y, this.x, this.y + this.h, color);
            g.fill(this.x + this.w, this.y, this.parent.width, this.y + this.h, color);
        }
    }

    public void startClip(GuiGraphics g) {
        g.enableScissor(this.x, this.y, this.x + this.w, this.y + this.h);
    }

    public void endClip(GuiGraphics g) {
        g.disableScissor();
    }

    public static enum RenderType {
        MARGIN,
        FILL,
        MARGIN_ALL;

    }
}

