/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.recipe.thunder;

import dev.xkmc.glimmeringtales.init.reg.GTRecipes;
import dev.xkmc.l2core.serial.recipe.BaseRecipe;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

@SerialClass
public class StrikeBlockRecipe
extends BaseRecipe<StrikeBlockRecipe, StrikeBlockRecipe, Inv> {
    @SerialField
    public Ingredient ingredient;
    @SerialField
    public Block transformTo;
    @SerialField
    public ItemStack result;

    public StrikeBlockRecipe() {
        super((BaseRecipe.RecType)GTRecipes.RS_STRIKE_BLOCK.get());
    }

    public boolean matches(Inv inv, Level level) {
        return this.ingredient.test(inv.state.getBlock().asItem().getDefaultInstance());
    }

    public ItemStack assemble(Inv inv, HolderLookup.Provider access) {
        inv.setBlock(this.transformTo.defaultBlockState(), this.result.copy());
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        return this.result;
    }

    public record Inv(Level level, BlockState state, BlockPos pos) implements RecipeInput
    {
        public boolean isEmpty() {
            return false;
        }

        public ItemStack getItem(int i) {
            return ItemStack.EMPTY;
        }

        public int size() {
            return 1;
        }

        public void setBlock(BlockState ans, ItemStack stack) {
            if (ans.isAir()) {
                this.level.removeBlock(this.pos, false);
                Block.popResource((Level)this.level, (BlockPos)this.pos, (ItemStack)stack);
            } else {
                this.level.setBlockAndUpdate(this.pos, ans);
                Block.popResource((Level)this.level, (BlockPos)this.pos.above(), (ItemStack)stack);
            }
        }
    }
}

