/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.recipe.ritual;

import dev.xkmc.glimmeringtales.content.block.altar.CoreRitualBlockEntity;
import dev.xkmc.glimmeringtales.content.block.altar.SideRitualBlockEntity;
import dev.xkmc.glimmeringtales.content.recipe.ritual.RitualRecipe;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class RitualInput
implements RecipeInput {
    protected final CoreRitualBlockEntity core;
    protected final List<SideRitualBlockEntity> list;
    private RitualRecipe<?> cachedRecipe = null;
    private int[] cachedResult = null;

    public RitualInput(CoreRitualBlockEntity core, List<SideRitualBlockEntity> list) {
        this.core = core;
        this.list = list.stream().filter(e -> !e.getItem().isEmpty()).toList();
    }

    public boolean match(RitualRecipe<?> recipe) {
        if (this.cachedRecipe == recipe) {
            return this.cachedResult != null;
        }
        this.cachedRecipe = recipe;
        if (!recipe.core.ingredient().test(this.core.getItem())) {
            return false;
        }
        this.cachedResult = RecipeMatcher.findMatches(this.list, recipe.getPredicates());
        return this.cachedResult != null;
    }

    public void assemble(RitualRecipe<?> recipe) {
        if (!this.match(recipe)) {
            return;
        }
        if (this.cachedResult == null) {
            return;
        }
        for (int i = 0; i < this.cachedResult.length; ++i) {
            this.list.get(i).setItem(recipe.list.get(this.cachedResult[i]).remainder().copy());
        }
    }

    public ItemStack getItem(int slot) {
        return slot == 0 ? this.core.getItem() : this.list.get(slot - 1).getItem();
    }

    public int size() {
        return this.list.size() + 1;
    }
}

