/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.item.wand;

import dev.xkmc.glimmeringtales.content.core.spell.ElementAffinity;
import dev.xkmc.glimmeringtales.content.core.spell.SpellElement;
import dev.xkmc.glimmeringtales.content.item.wand.WandData;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WandHandleItem
extends Item {
    private final ResourceLocation id;

    public WandHandleItem(Item.Properties prop, ResourceLocation id) {
        super(prop);
        this.id = id;
    }

    public ModelResourceLocation model() {
        return ModelResourceLocation.standalone((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this).withPath(e -> "item/" + e + "_handle"));
    }

    public ModelResourceLocation icon() {
        return ModelResourceLocation.standalone((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this).withPath(e -> "item/" + e + "_icon"));
    }

    public WandData data(@Nullable RegistryAccess access) {
        if (access == null) {
            return WandData.DEF;
        }
        WandData ans = (WandData)GTRegistries.WAND_MODEL.get(access, (Holder)this.builtInRegistryHolder());
        return ans == null ? WandData.DEF : ans;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        Level level = ctx.level();
        if (level == null) {
            return;
        }
        this.appendAffinityDesc(level, list);
    }

    public void appendAffinityDesc(Level level, List<Component> list) {
        ElementAffinity aff = this.getAffinity(level);
        if (aff == null) {
            return;
        }
        for (Map.Entry<SpellElement, Double> e : aff.affinity().entrySet()) {
            MutableComponent val = Component.literal((String)("+" + (int)Math.round(e.getValue() * 100.0) + "%")).withStyle(ChatFormatting.BLUE);
            list.add((Component)GTLang.TOOLTIP_AFFINITY.get(e.getKey().coloredDesc(), val).withStyle(ChatFormatting.GRAY));
        }
    }

    @Nullable
    public ElementAffinity getAffinity(Level level) {
        return (ElementAffinity)GTRegistries.AFFINITY.get(level.registryAccess(), (Holder)this.builtInRegistryHolder());
    }

    public ResourceLocation getFrame() {
        return BuiltInRegistries.ITEM.getKey((Object)this);
    }
}

