/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.item.wand;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xkmc.glimmeringtales.content.capability.PlayerManaCapability;
import dev.xkmc.glimmeringtales.content.core.spell.SpellCost;
import dev.xkmc.glimmeringtales.content.item.wand.IWandCoreItem;
import dev.xkmc.glimmeringtales.content.item.wand.RuneWandItem;
import dev.xkmc.glimmeringtales.init.GlimmeringTales;
import dev.xkmc.glimmeringtales.init.reg.GTItems;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.joml.Matrix4f;

public class SpellCastingOverlay
implements LayeredDraw.Layer {
    private static final ResourceLocation FRAME = GlimmeringTales.loc("mana_frame");
    private static final ResourceLocation FOCUS = GlimmeringTales.loc("mana_bar");
    private static final ResourceLocation BAR = GlimmeringTales.loc("focus_bar");
    private static final ResourceLocation RED = GlimmeringTales.loc("insufficient");
    private static final int W = 64;
    private static final int FW = 76;
    private static final int FH = 8;

    public void render(GuiGraphics g, DeltaTracker delta) {
        float pTick = delta.getGameTimeDeltaPartialTick(true);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        PlayerManaCapability mana = ((PlayerCapabilityHolder)GTRegistries.MANA.type()).getExisting((IAttachmentHolder)player).orElse(null);
        if (mana == null) {
            return;
        }
        double maxMana = player.getAttributeValue(GTRegistries.MAX_MANA);
        double valMana = mana.getMana();
        double maxFocus = player.getAttributeValue(GTRegistries.MAX_FOCUS);
        double valFocus = mana.getFocus();
        ItemStack wand = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!wand.is(GTItems.WAND)) {
            wand = player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (wand.is(GTItems.WAND)) {
            int w = g.guiWidth();
            int h = g.guiHeight();
            int x0 = w / 2;
            int y0 = (int)((double)h * 0.625) - 4;
            g.blitSprite(FRAME, x0 - 38, y0, 76, 8);
            ItemStack core = RuneWandItem.getCore(wand);
            SpellCost cost = SpellCost.ZERO;
            Item item = core.getItem();
            if (item instanceof IWandCoreItem) {
                IWandCoreItem item2 = (IWandCoreItem)item;
                cost = item2.getSpellInfo((Player)player).getCost((LivingEntity)player, wand);
            }
            SpellCastingOverlay.blitSprite(g, cost.focus() > valFocus ? RED : FOCUS, x0 - 32, y0 + 2, (float)(valFocus / maxFocus), 1.0f);
            SpellCastingOverlay.blitSprite(g, cost.mana() > valMana ? RED : BAR, x0 - 32, y0 + 4, (float)(valMana / maxMana), 2.0f);
        }
    }

    private static void blitSprite(GuiGraphics g, ResourceLocation id, int x, int y, float w, float h) {
        TextureAtlasSprite sp = Minecraft.getInstance().getGuiSprites().getSprite(id);
        SpellCastingOverlay.innerBlit(g, sp.atlasLocation(), x, (float)x + w * 64.0f, y, (float)y + h, sp.getU(0.0f), sp.getU(w), sp.getV(0.0f), sp.getV(1.0f));
    }

    private static void innerBlit(GuiGraphics g, ResourceLocation tex, float x1, float x2, float y1, float y2, float u0, float u1, float v0, float v1) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f m = g.pose().last().pose();
        BufferBuilder b = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        b.addVertex(m, x1, y1, 0.0f).setUv(u0, v0);
        b.addVertex(m, x1, y2, 0.0f).setUv(u0, v1);
        b.addVertex(m, x2, y2, 0.0f).setUv(u1, v1);
        b.addVertex(m, x2, y1, 0.0f).setUv(u1, v0);
        BufferUploader.drawWithShader((MeshData)b.buildOrThrow());
    }
}

