/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.item.wand;

import com.tterrag.registrate.util.CreativeModeTabModifier;
import dev.xkmc.glimmeringtales.content.item.wand.ISpellHolder;
import dev.xkmc.glimmeringtales.content.item.wand.IWandCoreItem;
import dev.xkmc.glimmeringtales.content.item.wand.SpellCastContext;
import dev.xkmc.glimmeringtales.content.item.wand.WandHandleItem;
import dev.xkmc.glimmeringtales.content.item.wand.WandMenu;
import dev.xkmc.glimmeringtales.init.data.GTConfigs;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import dev.xkmc.glimmeringtales.init.reg.GTItems;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.common.SimpleMenuPvd;
import dev.xkmc.l2backpack.content.quickswap.common.SingleSwapItem;
import dev.xkmc.l2backpack.content.quickswap.common.SingleSwapToken;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapType;
import dev.xkmc.l2library.content.raytrace.FastItem;
import dev.xkmc.l2library.content.raytrace.IGlowingTarget;
import dev.xkmc.l2library.content.raytrace.RayTraceUtil;
import dev.xkmc.l2magic.content.engine.spell.SpellCastType;
import dev.xkmc.l2menustacker.init.L2MSLangData;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RuneWandItem
extends SingleSwapItem
implements IGlowingTarget,
FastItem {
    public static WandHandleItem getHandle(ItemStack stack) {
        WandHandleItem handle;
        Holder item = (Holder)GTItems.WAND_HANDLE.getOrDefault(stack, (Object)GTItems.WOOD_WAND.item());
        Object object = item.value();
        return object instanceof WandHandleItem ? (handle = (WandHandleItem)((Object)object)) : (WandHandleItem)GTItems.WOOD_WAND.get();
    }

    public static ItemStack getCore(ItemStack stack) {
        return (ItemStack)RuneWandItem.getItems((ItemStack)stack).get(RuneWandItem.getSelected((ItemStack)stack));
    }

    public RuneWandItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public IQuickSwapToken<?> getTokenOfType(ItemStack stack, LivingEntity le, QuickSwapType type) {
        return type == GTRegistries.SWAP ? new SingleSwapToken((IQuickSwapItem)this, stack, type) : null;
    }

    public boolean isValidContent(ItemStack stack) {
        return stack.getItem() instanceof IWandCoreItem;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (isSelected && level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            RayTraceUtil.clientUpdateTarget((Player)player, (double)this.getDistance(stack));
        }
    }

    public int getDistance(ItemStack stack) {
        int n;
        Item item = RuneWandItem.getCore(stack).getItem();
        if (item instanceof IWandCoreItem) {
            IWandCoreItem item2 = (IWandCoreItem)item;
            n = item2.entityTrace();
        } else {
            n = 0;
        }
        return n;
    }

    public int getUseDuration(ItemStack stack, LivingEntity e) {
        return 72000;
    }

    public boolean isFast(ItemStack itemStack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ISpellHolder spell = this.getSpell(stack, level);
        if (spell != null) {
            if (spell.castType() == SpellCastType.INSTANT) {
                if (this.castSpell(stack, level, (LivingEntity)player, spell, 0, false)) {
                    return InteractionResultHolder.consume((Object)stack);
                }
                return InteractionResultHolder.fail((Object)stack);
            }
            if (this.checkMana(stack, level, (LivingEntity)player, spell, 0, spell.castType() == SpellCastType.CHARGE)) {
                return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int remain) {
        super.onUseTick(level, user, stack, remain);
        ISpellHolder spell = this.getSpell(stack, level);
        if (spell != null) {
            boolean pass = false;
            if (spell.castType() == SpellCastType.CONTINUOUS) {
                pass = this.castSpell(stack, level, user, spell, this.getUseDuration(stack, user) - remain, false);
            }
            if (spell.castType() == SpellCastType.CHARGE) {
                pass = this.castSpell(stack, level, user, spell, this.getUseDuration(stack, user) - remain, true);
            }
            if (!pass) {
                user.useItemRemaining = 0;
                user.stopUsingItem();
            }
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity user, int remain) {
        ISpellHolder spell = this.getSpell(stack, level);
        if (spell != null && spell.castType() == SpellCastType.CHARGE) {
            this.castSpell(stack, level, user, spell, this.getUseDuration(stack, user) - remain, false);
        }
    }

    @Nullable
    private ISpellHolder getSpell(ItemStack stack, Level level) {
        ISpellHolder iSpellHolder;
        ItemStack sel = RuneWandItem.getCore(stack);
        Item item = sel.getItem();
        if (item instanceof IWandCoreItem) {
            IWandCoreItem item2 = (IWandCoreItem)item;
            iSpellHolder = item2.getSpell(sel, level);
        } else {
            iSpellHolder = null;
        }
        return iSpellHolder;
    }

    private boolean castSpell(ItemStack stack, Level level, LivingEntity user, ISpellHolder spell, int useTick, boolean charging) {
        int delay = (int)Math.round((double)spell.getStandardDelay(level) * (Double)GTConfigs.SERVER.playerCastingDelayFactor.get());
        return spell.cast(SpellCastContext.of(level, user, delay, stack), useTick, charging);
    }

    private boolean checkMana(ItemStack stack, Level level, LivingEntity user, ISpellHolder spell, int useTick, boolean charging) {
        return spell.cast(SpellCastContext.simulate(level, user, stack), useTick, charging);
    }

    public void fillCreativeTabs(CreativeModeTabModifier x) {
        for (WandHandleItem e : GTItems.HANDLES) {
            x.accept(GTItems.WAND_HANDLE.set(this.getDefaultInstance(), (Object)e.builtInRegistryHolder()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public Component getName(ItemStack stack) {
        WandHandleItem handle = RuneWandItem.getHandle(stack);
        return Component.translatable((String)handle.getDescriptionId()).append(super.getName(stack));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        Level level = ctx.level();
        if (level != null) {
            ItemStack core = RuneWandItem.getCore(stack);
            if (!core.isEmpty()) {
                list.add((Component)GTLang.TOOLTIP_SELECTED.get(core.getHoverName()).withStyle(ChatFormatting.GRAY));
            }
            WandHandleItem handle = RuneWandItem.getHandle(stack);
            list.add((Component)Component.translatable((String)handle.getDescriptionId()).append(": "));
            handle.appendAffinityDesc(level, list);
        }
        list.add((Component)L2MSLangData.QUICK_ACCESS.get(new Object[0]).withStyle(ChatFormatting.GRAY));
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.MAINHAND;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return armorType == EquipmentSlot.MAINHAND;
    }

    public void open(ServerPlayer player, PlayerSlot<?> slot, ItemStack stack) {
        new SimpleMenuPvd(player, slot, (BaseBagItem)this, stack, WandMenu::new).open();
    }
}

