/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.item.wand;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.glimmeringtales.content.item.wand.IWandCoreItem;
import dev.xkmc.glimmeringtales.content.item.wand.RuneWandItem;
import dev.xkmc.glimmeringtales.content.item.wand.WandData;
import dev.xkmc.glimmeringtales.content.item.wand.WandHandleItem;
import dev.xkmc.l2core.util.ServerProxy;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.apache.commons.lang3.function.Consumers;
import org.joml.Quaternionf;

public class GTBEWLR
extends BlockEntityWithoutLevelRenderer {
    public static final Supplier<BlockEntityWithoutLevelRenderer> INSTANCE = Suppliers.memoize(() -> new GTBEWLR(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels()));
    public static final IClientItemExtensions EXTENSIONS = new IClientItemExtensions(){

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return INSTANCE.get();
        }
    };

    public GTBEWLR(BlockEntityRenderDispatcher dispatcher, EntityModelSet set) {
        super(dispatcher, set);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext type, PoseStack pose, MultiBufferSource bufferSource, int light, int overlay) {
        if (stack.getItem() instanceof RuneWandItem) {
            this.renderWand(stack, type, pose, bufferSource, light, overlay);
        }
    }

    public void renderWand(ItemStack stack, ItemDisplayContext type, PoseStack pose, MultiBufferSource bufferSource, int light, int overlay) {
        ModelManager manager = Minecraft.getInstance().getModelManager();
        WandHandleItem handle = RuneWandItem.getHandle(stack);
        if (type == ItemDisplayContext.GUI) {
            this.render(stack, pose, bufferSource, light, overlay, manager.getModel(handle.icon()), Consumers.nop());
            return;
        }
        this.render(stack, pose, bufferSource, light, overlay, manager.getModel(handle.model()), GTBEWLR::wandHandle);
        ItemStack sel = RuneWandItem.getCore(stack);
        Item item = sel.getItem();
        if (item instanceof IWandCoreItem) {
            IWandCoreItem core = (IWandCoreItem)item;
            this.render(sel, pose, bufferSource, light, overlay, manager.getModel(core.model()), p -> GTBEWLR.wandCore(handle, p));
        }
    }

    private static void wandHandle(PoseStack pose) {
        pose.rotateAround(Axis.YP.rotationDegrees(90.0f), 0.5f, 0.5f, 0.5f);
    }

    private static void wandCore(WandHandleItem item, PoseStack pose) {
        LocalPlayer pl = Minecraft.getInstance().player;
        if (pl == null) {
            return;
        }
        float tick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true) + (float)pl.tickCount;
        WandData data = item.data(ServerProxy.getRegistryAccess());
        float size = data.size();
        pose.translate(0.5, 0.5, 0.5);
        pose.translate(0.0f, data.offset(), 0.0f);
        pose.rotateAround(Axis.YP.rotationDegrees(tick * 20.0f), 0.0f, 0.0f, 0.0f);
        pose.rotateAround(new Quaternionf().rotateTo(1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f), 0.0f, 0.0f, 0.0f);
        pose.scale(size, size, size);
        pose.translate(-0.5, -0.5, -0.5);
    }

    public void render(ItemStack stack, PoseStack pose, MultiBufferSource buffer, int light, int overlay, BakedModel baked, Consumer<PoseStack> transform) {
        ItemRenderer ir = Minecraft.getInstance().getItemRenderer();
        if (!stack.isEmpty()) {
            pose.pushPose();
            transform.accept(pose);
            for (BakedModel model : baked.getRenderPasses(stack, true)) {
                for (RenderType rendertype : model.getRenderTypes(stack, true)) {
                    if (rendertype.name.startsWith("glimmeringtales_ender")) {
                        rendertype = RenderType.END_GATEWAY;
                    }
                    VertexConsumer vc = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.hasFoil());
                    ir.renderModelLists(model, stack, light, overlay, pose, vc);
                }
            }
            pose.popPose();
        }
    }
}

