/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.item.rune;

import dev.xkmc.glimmeringtales.content.core.spell.BlockSpell;
import dev.xkmc.glimmeringtales.content.core.spell.ElementAffinity;
import dev.xkmc.glimmeringtales.content.core.spell.NatureSpell;
import dev.xkmc.glimmeringtales.content.core.spell.SpellElement;
import dev.xkmc.glimmeringtales.content.core.spell.SpellInfo;
import dev.xkmc.glimmeringtales.content.item.materials.LightningImmuneItem;
import dev.xkmc.glimmeringtales.content.item.rune.BlockSpellContext;
import dev.xkmc.glimmeringtales.content.item.rune.IBlockSpellItem;
import dev.xkmc.glimmeringtales.content.item.wand.SpellCastContext;
import dev.xkmc.glimmeringtales.init.data.GTConfigs;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SpellCoreItem
extends LightningImmuneItem
implements IBlockSpellItem {
    public SpellCoreItem(Item.Properties prop) {
        super(prop);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        Level level = ctx.level();
        if (level == null) {
            return;
        }
        ElementAffinity aff = this.getAffinity(level);
        if (aff == null) {
            return;
        }
        for (Map.Entry<SpellElement, Double> e : aff.affinity().entrySet()) {
            MutableComponent val = Component.literal((String)((int)Math.round(e.getValue() * 100.0) + "%")).withStyle(ChatFormatting.BLUE);
            list.add((Component)GTLang.TOOLTIP_AFFINITY.get(e.getKey().coloredDesc(), val).withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public int entityTrace() {
        return 0;
    }

    @Nullable
    public ElementAffinity getAffinity(Level level) {
        return (ElementAffinity)GTRegistries.AFFINITY.get(level.registryAccess(), (Holder)this.builtInRegistryHolder());
    }

    @Override
    public int getStandardDelay(Level level) {
        return 0;
    }

    @Override
    public SpellInfo getSpellInfo(Player player) {
        BlockSpellContext ctx = BlockSpellContext.blockSpellContext((LivingEntity)player, this.range(), 0);
        if (ctx == null) {
            return SpellInfo.EMPTY;
        }
        BlockSpell spell = (BlockSpell)GTRegistries.BLOCK.get(player.level().registryAccess(), ctx.state().getBlockHolder());
        if (spell == null) {
            return SpellInfo.EMPTY;
        }
        NatureSpell nature = (NatureSpell)spell.spell().value();
        ElementAffinity aff = this.getAffinity(player.level());
        if (aff == null || !aff.affinity().containsKey((Object)nature.elem())) {
            return SpellInfo.EMPTY;
        }
        return SpellInfo.ofBlock(spell, aff);
    }

    @Override
    public boolean castSpell(SpellCastContext user) {
        BlockSpellContext ctx = BlockSpellContext.blockSpellContext(user.user(), this.range(), user.delay());
        if (ctx == null) {
            return false;
        }
        BlockSpell spell = (BlockSpell)GTRegistries.BLOCK.get(user.level().registryAccess(), ctx.state().getBlockHolder());
        if (spell == null) {
            return false;
        }
        NatureSpell nature = (NatureSpell)spell.spell().value();
        ElementAffinity aff = this.getAffinity(user.level());
        if (aff == null || !aff.affinity().containsKey((Object)nature.elem())) {
            return false;
        }
        if (!user.level().isClientSide() && spell.breakBlock()) {
            user.level().removeBlock(ctx.pos(), false);
        }
        return this.execute(nature, ctx.ctx(), user, aff, 0, false);
    }

    public int range() {
        return (Integer)GTConfigs.SERVER.wandInteractionDistance.get();
    }

    @Override
    public ModelResourceLocation model() {
        return ModelResourceLocation.standalone((ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this).withPath(e -> "item/" + e + "_core"));
    }
}

