/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.item.rune;

import dev.xkmc.glimmeringtales.content.core.spell.RuneBlock;
import dev.xkmc.l2magic.content.engine.context.SpellContext;
import dev.xkmc.l2magic.content.engine.helper.Orientation;
import io.netty.util.internal.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public record BlockSpellContext(SpellContext ctx, BlockState state, BlockPos pos) {
    @Nullable
    public static BlockSpellContext blockSpellContext(LivingEntity user, int distance, int delay) {
        Vec3 forward;
        Vec3 end;
        Vec3 start;
        Level level = user.level();
        BlockHitResult bhit = level.clip(new ClipContext(start = user.getEyePosition(), end = start.add((forward = SpellContext.getForward((LivingEntity)user)).scale((double)distance)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)user));
        if (bhit.getType() == HitResult.Type.MISS) {
            return null;
        }
        BlockPos pos = bhit.getBlockPos();
        Orientation ori = Orientation.regular().asNormal();
        long seed = 0L;
        if (!level.isClientSide()) {
            seed = ThreadLocalRandom.current().nextLong();
        }
        SpellContext ctx = new SpellContext(user, pos.getCenter(), ori, seed, 0.0, 1.0, delay);
        return new BlockSpellContext(ctx, level.getBlockState(pos), pos);
    }

    @Nullable
    public static BlockSpellContext entitySpellContext(LivingEntity user, int distance, RuneBlock spell, int delay) {
        BlockPos pos;
        Level level = user.level();
        Vec3 start = user.getEyePosition();
        Vec3 forward = SpellContext.getForward((LivingEntity)user);
        Vec3 end = start.add(forward.scale((double)distance));
        AABB box = new AABB(start, end).inflate(1.0);
        BlockHitResult bhit = level.clip(new ClipContext(start, end, ClipContext.Block.OUTLINE, spell.targetLiquid() ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)user));
        EntityHitResult ehit = ProjectileUtil.getEntityHitResult((Level)level, (Entity)user, (Vec3)start, (Vec3)end, (AABB)box, e -> true);
        if (ehit != null && ehit.getType() != HitResult.Type.MISS) {
            pos = ehit.getEntity().blockPosition().below().offset(0, spell.noBlockOffset(), 0);
        } else if (bhit.getType() != HitResult.Type.MISS) {
            pos = bhit.getBlockPos().relative(bhit.getDirection(), spell.noBlockOffset());
        } else if (spell.allowSelf()) {
            pos = user.blockPosition().below();
        } else {
            return null;
        }
        Orientation ori = Orientation.regular().asNormal();
        long seed = 0L;
        if (!level.isClientSide()) {
            seed = ThreadLocalRandom.current().nextLong();
        }
        SpellContext ctx = new SpellContext(user, pos.getCenter(), ori, seed, 0.0, 1.0, delay);
        return new BlockSpellContext(ctx, level.getBlockState(pos), pos);
    }
}

