/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.item.rune;

import dev.xkmc.glimmeringtales.content.core.spell.DefaultAffinity;
import dev.xkmc.glimmeringtales.content.core.spell.NatureSpell;
import dev.xkmc.glimmeringtales.content.core.spell.RuneBlock;
import dev.xkmc.glimmeringtales.content.core.spell.SpellInfo;
import dev.xkmc.glimmeringtales.content.entity.hostile.MobCastingData;
import dev.xkmc.glimmeringtales.content.item.rune.BaseRuneItem;
import dev.xkmc.glimmeringtales.content.item.rune.BlockSpellContext;
import dev.xkmc.glimmeringtales.content.item.rune.IBlockSpellItem;
import dev.xkmc.glimmeringtales.content.item.wand.SpellCastContext;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class BlockRuneItem
extends BaseRuneItem
implements IBlockSpellItem {
    public BlockRuneItem(Item.Properties properties) {
        super(properties);
    }

    public Optional<RuneBlock> getSpell(RegistryAccess access) {
        return Optional.ofNullable((RuneBlock)GTRegistries.RUNE_BLOCK.get(access, (Holder)this.builtInRegistryHolder()));
    }

    @Override
    public SpellInfo getSpellInfo(RegistryAccess access) {
        return SpellInfo.ofRune(this.getSpell(access).orElse(null));
    }

    @Override
    public int getStandardDelay(Level level) {
        Optional<RuneBlock> spell = this.getSpell(level.registryAccess());
        if (spell.isEmpty()) {
            return 0;
        }
        MobCastingData mob = ((NatureSpell)spell.get().spell().value()).mob();
        if (mob == null) {
            return 0;
        }
        return mob.standardDelay();
    }

    @Override
    public boolean castSpell(SpellCastContext user) {
        Optional<RuneBlock> opt = this.getSpell(user.level().registryAccess());
        if (opt.isEmpty()) {
            return false;
        }
        RuneBlock spell = opt.get();
        BlockSpellContext ctx = BlockSpellContext.entitySpellContext(user.user(), this.entityTrace(), spell, user.delay());
        if (ctx == null) {
            return false;
        }
        return this.execute((NatureSpell)spell.spell().value(), ctx.ctx(), user, DefaultAffinity.INS, 0, false);
    }
}

