/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.item.materials;

import dev.xkmc.glimmeringtales.content.item.materials.IFoodItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class VialItem
extends Item {
    private final List<Supplier<MobEffectInstance>> effects;

    public VialItem(Item.Properties prop, List<Supplier<MobEffectInstance>> effects) {
        super(prop);
        this.effects = effects;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity e) {
        return 10;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.getCooldowns().addCooldown((Item)this, 1000);
            }
            for (Supplier<MobEffectInstance> e : this.effects) {
                entity.addEffect(e.get());
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        for (Supplier<MobEffectInstance> e : this.effects) {
            list.add(IFoodItem.getTooltip(e.get()));
        }
    }
}

