/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.item.materials;

import dev.xkmc.glimmeringtales.content.item.materials.LightningImmuneItem;
import dev.xkmc.glimmeringtales.init.data.GTLang;
import dev.xkmc.glimmeringtales.init.reg.GTItems;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DepletedItem
extends LightningImmuneItem {
    private final Supplier<Block> pred;
    private final IntSupplier count;
    private final Supplier<Item> next;
    private final Supplier<SoundEvent> sound;

    public DepletedItem(Item.Properties properties, Supplier<Block> pred, IntSupplier count, Supplier<Item> next, Supplier<SoundEvent> sound) {
        super(properties.stacksTo(1));
        this.pred = pred;
        this.count = count;
        this.next = next;
        this.sound = sound;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState state;
        BlockHitResult hit;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (!this.pred.get().defaultBlockState().getFluidState().isEmpty() && (hit = DepletedItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)).getType() == HitResult.Type.BLOCK) {
            pos = hit.getBlockPos();
        }
        if ((state = level.getBlockState(pos)).is(this.pred.get())) {
            if (!level.isClientSide()) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                int use = (Integer)GTItems.PROGRESS.getOrDefault(stack, (Object)0) + 1;
                if (use >= this.count.getAsInt()) {
                    player.setItemInHand(context.getHand(), this.next.get().getDefaultInstance());
                } else {
                    GTItems.PROGRESS.set(stack, (Object)use);
                }
            }
            player.playSound(this.sound.get(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return -1;
    }

    public int getBarWidth(ItemStack stack) {
        int use = (Integer)GTItems.PROGRESS.getOrDefault(stack, (Object)0);
        float prog = 13.0f * Math.clamp(1.0f * (float)use / (float)this.count.getAsInt(), 0.0f, 1.0f);
        return Math.round(prog);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)GTLang.TOOLTIP_BLOCK.get(Component.translatable((String)this.pred.get().getDescriptionId()).withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GRAY));
        int use = (Integer)GTItems.PROGRESS.getOrDefault(stack, (Object)0);
        list.add((Component)GTLang.TOOLTIP_FILL.get(Component.literal((String)("" + use)).withStyle(ChatFormatting.DARK_AQUA), Component.literal((String)("" + this.count.getAsInt())).withStyle(ChatFormatting.DARK_AQUA)).withStyle(ChatFormatting.GRAY));
    }
}

