/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.item.curio;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import dev.xkmc.glimmeringtales.content.item.curio.AttributeData;
import dev.xkmc.glimmeringtales.content.item.curio.GTCurioItem;
import dev.xkmc.glimmeringtales.init.reg.GTRegistries;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import top.theillusivec4.curios.api.SlotContext;

public class AttributeCurioItem
extends GTCurioItem {
    public AttributeCurioItem(Item.Properties properties) {
        super(properties);
    }

    private Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(RegistryAccess access, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap ans = LinkedHashMultimap.create();
        AttributeData attrs = (AttributeData)GTRegistries.ITEM_ATTR.get(access, stack.getItemHolder());
        if (attrs == null) {
            return ans;
        }
        for (AttributeData.Entry e : attrs.list()) {
            ans.put(e.attribute(), (Object)new AttributeModifier(id, e.value(), e.operation()));
        }
        return ans;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext ctx, ResourceLocation id, ItemStack stack) {
        return this.getAttributeModifiers(AttributeCurioItem.getAccess(ctx.entity()), id, stack);
    }

    @Nullable
    private static RegistryAccess getAccess(@Nullable LivingEntity e) {
        ClientLevel level;
        if (e != null) {
            return e.level().registryAccess();
        }
        if (FMLEnvironment.dist == Dist.CLIENT && (level = Minecraft.getInstance().level) != null) {
            return level.registryAccess();
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.registryAccess();
        }
        return null;
    }
}

