/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.entity.misc;

import dev.xkmc.glimmeringtales.init.data.GTDamageTypeGen;
import dev.xkmc.glimmeringtales.init.reg.GTEntities;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class GTFallingBlockEntity
extends FallingBlockEntity
implements TraceableEntity {
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;

    public GTFallingBlockEntity(EntityType<GTFallingBlockEntity> entityType, Level level) {
        super(entityType, level);
    }

    public GTFallingBlockEntity(Level level, double x, double y, double z, BlockState state) {
        this((EntityType<GTFallingBlockEntity>)((EntityType)GTEntities.FALLING.get()), level);
        this.blockState = state;
        this.blocksBuilding = true;
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setStartPos(this.blockPosition());
    }

    private DamageSource damageSource(DamageSource old) {
        LivingEntity le;
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity && (le = (LivingEntity)entity).level() == this.level() && (entity = this.level()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)entity;
            return AttackEventHandler.createSource((ServerLevel)sl, (LivingEntity)le, GTDamageTypeGen.FALLING, (Entity)this, null);
        }
        return old;
    }

    public void setOwner(@Nullable Entity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.getUUID();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.level() instanceof ServerLevel) {
            this.cachedOwner = ((ServerLevel)this.level()).getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    @OverridingMethodsMustInvokeSuper
    protected void addAdditionalSaveData(CompoundTag nbt) {
        if (this.ownerUUID != null) {
            nbt.putUUID("Owner", this.ownerUUID);
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.hasUUID("Owner")) {
            this.ownerUUID = nbt.getUUID("Owner");
            this.cachedOwner = null;
        }
    }

    public DamageSources damageSources() {
        return new CustomSources(this.level().registryAccess());
    }

    private static class CustomSources
    extends DamageSources {
        public CustomSources(RegistryAccess registry) {
            super(registry);
        }

        public DamageSource fallingBlock(Entity entity) {
            if (entity instanceof GTFallingBlockEntity) {
                GTFallingBlockEntity fall = (GTFallingBlockEntity)entity;
                return fall.damageSource(super.fallingBlock(entity));
            }
            return super.fallingBlock(entity);
        }
    }
}

