/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.glimmeringtales.content.entity.hostile;

import dev.xkmc.glimmeringtales.content.entity.hostile.MobCastingConfig;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class StrafingRangedAttackGoal
extends Goal {
    protected final Mob mob;
    protected final MobCastingConfig config;
    @Nullable
    private LivingEntity target;
    protected long nextAttackTimestamp = 0L;
    protected int seeTime;
    protected int immobileTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public StrafingRangedAttackGoal(Mob mob, MobCastingConfig config) {
        this.mob = mob;
        this.config = config;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        if (target != null && target.isAlive()) {
            this.target = target;
            return this.canCastSpell();
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse() || this.target != null && this.target.isAlive() && !this.mob.getNavigation().isDone();
    }

    public void start() {
        this.mob.setAggressive(true);
    }

    public void stop() {
        this.mob.setAggressive(false);
        this.target = null;
        this.seeTime = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.target == null) {
            return;
        }
        double sqr = this.getAttackRangeSqr(this.target);
        double distSqr = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        boolean canSee = this.mob.getSensing().hasLineOfSight((Entity)this.target);
        this.seeTime = canSee ? ++this.seeTime : 0;
        if (this.immobileTime > 0) {
            --this.immobileTime;
            this.strafingTime = -1;
            this.mob.getNavigation().stop();
            this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        } else {
            if (distSqr <= sqr && this.seeTime >= this.config.stopMovingSeeTime()) {
                this.mob.getNavigation().stop();
                ++this.strafingTime;
            } else {
                this.mob.getNavigation().moveTo((Entity)this.target, this.config.speed());
                this.strafingTime = -1;
            }
            if (this.strafingTime >= this.config.strafRotateTime()) {
                if (this.mob.getRandom().nextFloat() < this.config.switchRotationChance()) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if (this.mob.getRandom().nextFloat() < this.config.switchDirectionChance()) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                Entity entity;
                if (distSqr > sqr * this.config.stopBackoffRange()) {
                    this.strafingBackwards = false;
                } else if (distSqr < sqr * this.config.startBackoffRange()) {
                    this.strafingBackwards = true;
                }
                this.mob.getMoveControl().strafe(this.strafingBackwards ? -1.0f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                if (this.mob.onGround() && this.mob.level().getBlockState(this.mob.blockPosition()).isSolid()) {
                    this.mob.getJumpControl().jump();
                }
                if ((entity = this.mob.getControlledVehicle()) instanceof Mob) {
                    Mob veh = (Mob)entity;
                    veh.lookAt((Entity)this.target, 30.0f, 30.0f);
                }
                this.mob.lookAt((Entity)this.target, 30.0f, 30.0f);
            } else {
                this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
            }
        }
        long timestamp = this.mob.level().getGameTime();
        if (this.nextAttackTimestamp <= timestamp) {
            this.nextAttackTimestamp = timestamp + (long)this.attack(this.target, distSqr <= sqr && canSee);
        }
    }

    protected abstract double getAttackRangeSqr(LivingEntity var1);

    protected abstract int attack(LivingEntity var1, boolean var2);

    protected abstract boolean canCastSpell();
}

